package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.GroupOfOccurrences;

import java.util.Optional;

public class CacheabilityPatternDecider {

    /**
     * Flowchart definition
     *
     * @param groupOfOccurrences
     * @return
     */
    public static boolean isCacheable(GroupOfOccurrences groupOfOccurrences) {
        //Is the data completely static?
        Optional<Boolean> isStaticData = CacheabilityMetrics.isStaticData(groupOfOccurrences);
        if (isStaticData.isPresent() && isStaticData.get()) { // staticity yes
            return true;
        }
        // staticity no/not sure
        Optional<Boolean> changeMoreThanUsed = CacheabilityMetrics.changeMoreThanUsed(groupOfOccurrences);
        if (changeMoreThanUsed.isPresent() && changeMoreThanUsed.get()) { //changeMoreThanUsed true
            return false;
        }
        //changeMoreThanUsed not/not sure
        Optional<Boolean> usedByManyRequests = CacheabilityMetrics.usedByManyRequests(groupOfOccurrences);
        if (usedByManyRequests.isPresent() && !usedByManyRequests.get()) { //useByManyRequests no
            return false;
        }
        Optional<Boolean> isUserSpecific = CacheabilityMetrics.isUserSpecific(groupOfOccurrences);
        if (isUserSpecific.isPresent() && isUserSpecific.get()) {
            return true;
        }
        Optional<Boolean> isExpensive = CacheabilityMetrics.isExpensive(groupOfOccurrences);
        return isExpensive.isPresent() ? isExpensive.get() : true;
    }
}
