/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats.CacheabilityPatternDecider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class Method {

    private static final Logger logger = Logger.getLogger(Method.class.getName());

    private final String name;
    private final List<Occurrence> occurrences;
    private List<GroupOfOccurrences> groupsOfOccurrences;

    public Method(String name) {
        this.name = name;
        this.occurrences = new ArrayList<>();
    }

    public Method addOccurrence(Occurrence occurrence) {
        this.occurrences.add(occurrence);
        return this;
    }

    public Method clearTraces() {
        this.occurrences.clear();
        return this;
    }

    public int getOccurrencesSize() {
        return this.occurrences.size();
    }

    public List<GroupOfOccurrences> getGroupsOfOccurrences() {
        return groupsOfOccurrences;
    }

    public void groupByParameter() {
        logger.log(Level.INFO, "Grouping by parameters {0} occurrences of {1}", new Object[]{this.name, this.occurrences.size()});
        Map<String, GroupOfOccurrences> groupByParameter = new HashMap<>();
        this.occurrences.stream().parallel().forEach(new Consumer<Occurrence>() {
            int i = 0;

            @Override
            public void accept(Occurrence occurrence) {
                String verbose = System.getenv("TRACER_VERBOSE");
                if (verbose != null && verbose.equals("true")) {
                    System.out.print(".");
                    System.out.flush();
                    if (++i % 100 == 0) {
                        System.out.println();
                    }
                }
                String parameters = Arrays.toString(occurrence.getParameters());
                synchronized (groupByParameter) {
                    try {
                        groupByParameter.get(parameters).addOccurrence(occurrence);
                    } catch (Exception e) {
                        GroupOfOccurrences groupOfOccurrences = new GroupOfOccurrences(parameters);
                        groupOfOccurrences.addOccurrence(occurrence);
                        groupByParameter.put(parameters, groupOfOccurrences);
                    }
                }
            }
        });
        this.groupsOfOccurrences = groupByParameter.values().stream().collect(Collectors.toList());
        groupByParameter.clear();
        this.occurrences.clear();
    }

    public void calculateMetrics() {
        groupByParameter();
        Collections.sort(this.groupsOfOccurrences, (g1, g2) -> Integer.compare(g1.getOccurrencesSize(), g2.getOccurrencesSize()));
        this.groupsOfOccurrences.stream().parallel().forEach(GroupOfOccurrences::calculateMetrics);
    }

    public void calculateThresholds() {
        this.groupsOfOccurrences.stream().forEach(GroupOfOccurrences::calculateThresholds);
    }

    public void filterCacheableInputs() {
        Iterator<GroupOfOccurrences> iterator = this.groupsOfOccurrences.iterator();
        while (iterator.hasNext()) {
            GroupOfOccurrences groupOfOccurrences = iterator.next();
            if (!CacheabilityPatternDecider.isCacheable(groupOfOccurrences)) {
                iterator.remove();
            }
        }
    }

    @Override
    public String toString() {
        return this.name;
    }
}
