package br.ufrgs.inf.prosoft.aplcache.metadata;

public abstract class Occurrence {

    private final long startTime;
    private final long endTime;
    private final String userId;

    public Occurrence(long startTime, long endTime, String userId) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.userId = userId;
    }

    public long getExecutionTime() {
        return endTime - startTime;
    }

    public String getUserId() {
        return userId;
    }

    public abstract Object[] getParameters();

    public abstract Object getReturnValue();

}
