/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author romulo
 */
public class Thresholds {

    public static double sumMissRatio;
    public static double sumHitRatio;
    public static double sumExecutionTime;
    public static double sumShareability;
    public static double sumFrequency;

    public static Double averageFrequency;

    public static Double stdDevHitRatio;
    public static Double stdDevMissRatio;
    public static Double stdDevExecutionTimeRatio;
    public static Double stdDevFrequency;
    public static Double stdDevShareability;

    public static long population;

    public static final List<Double> hitRatios = new ArrayList<>();
    public static final List<Double> missRatios = new ArrayList<>();
    public static final List<Long> executionTimes = new ArrayList<>();
    public static final List<Double> shareabilities = new ArrayList<>();
    public static final List<Long> frequencies = new ArrayList<>();

    public static void reset() {
        Thresholds.sumMissRatio = 0;
        Thresholds.sumHitRatio = 0;
        Thresholds.sumExecutionTime = 0;
        Thresholds.sumShareability = 0;
        Thresholds.sumFrequency = 0;

        Thresholds.averageFrequency = 0D;

        Thresholds.stdDevHitRatio = 0D;
        Thresholds.stdDevMissRatio = 0D;
        Thresholds.stdDevExecutionTimeRatio = 0D;
        Thresholds.stdDevFrequency = 0D;
        Thresholds.stdDevShareability = 0D;

        Thresholds.population = 0;

        Thresholds.hitRatios.clear();
        Thresholds.missRatios.clear();
        Thresholds.executionTimes.clear();
        Thresholds.shareabilities.clear();
        Thresholds.frequencies.clear();
    }

    /**
     * General mean hit ratio of all calls
     *
     * @return
     */
    public static double getAverageHitRatio() {
        if (population == 0) {
            return 0;
        }
        return new BigDecimal(sumHitRatio).divide(new BigDecimal(population), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public static double getAverageMissRatio() {
        if (population == 0) {
            return 0;
        }
        return new BigDecimal(sumMissRatio).divide(new BigDecimal(population), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public static double getAverageExecutionTime() {
        if (population == 0) {
            return 0;
        }
        return new BigDecimal(sumExecutionTime).divide(new BigDecimal(population), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public static double getAverageShareability() {
        if (population == 0) {
            return 0;
        }
        return new BigDecimal(sumShareability).divide(new BigDecimal(population), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public static double getStdDevHitRatio() {
        if (population == 0) {
            return 0;
        }
        if (stdDevHitRatio != null) {
            return stdDevHitRatio;
        }

        double mean = getAverageHitRatio();
        double temp = hitRatios.stream().parallel()
                .map(hitRate -> (hitRate - mean) * (hitRate - mean))
                .reduce(Double::sum)
                .get();
        stdDevHitRatio = Math.sqrt(temp / population);
        return stdDevHitRatio;
    }

    public static double getStdDevMissRatio() {
        if (population == 0) {
            return 0;
        }
        if (stdDevMissRatio != null) {
            return stdDevMissRatio;
        }

        double mean = getAverageMissRatio();
        double temp = 0;
        for (double a : missRatios) {
            temp += (a - mean) * (a - mean);
        }
        stdDevMissRatio = Math.sqrt(temp / population);
        return stdDevMissRatio;
    }

    public static double getStdDevExecutionTimeRatio() {
        if (population == 0) {
            return 0;
        }
        if (stdDevExecutionTimeRatio != null) {
            return stdDevExecutionTimeRatio;
        }

        double mean = getAverageExecutionTime();
        double temp = executionTimes.stream()
                .map(executionTime -> (executionTime - mean) * (executionTime - mean))
                .reduce(Double::sum).get();
        stdDevExecutionTimeRatio = Math.sqrt(temp / population);
        return stdDevExecutionTimeRatio;
    }

    public static double getStdDevFrequency() {
        if (population == 0) {
            return 0;
        }
        if (stdDevFrequency != null) {
            return stdDevFrequency;
        }

        double mean = getAverageFrequency();
        double temp = frequencies.stream()
                .map(frequency -> (frequency - mean) * (frequency - mean))
                .reduce(Double::sum).get();
        stdDevFrequency = Math.sqrt(temp / population);
        return stdDevFrequency;
    }

    public static double getStdDevShareability() {
        if (population == 0) {
            return 0;
        }
        if (stdDevShareability != null) {
            return stdDevShareability;
        }

        double mean = getAverageShareability();
        double temp = shareabilities.stream()
                .map(shareability -> (shareability - mean) * (shareability - mean))
                .reduce(Double::sum)
                .get();
        stdDevShareability = Math.sqrt(temp / population);
        return stdDevShareability;
    }

    public static double getAverageFrequency() {
        if (frequencies.isEmpty()) {
            return 0;
        }
        if (averageFrequency != null) {
            return averageFrequency;
        }

        averageFrequency = new BigDecimal(sumFrequency).divide(new BigDecimal(frequencies.size()), 5, RoundingMode.HALF_UP).doubleValue();
        return averageFrequency;
    }

//getting X% with most hits
    public static double hitThreshold(int kStdDev) {
        return getAverageHitRatio() + (kStdDev * getStdDevHitRatio());
    }

//getting X% with most misses
    public static double missThreshold(int kStdDev) {
        return getAverageMissRatio() + (kStdDev * getStdDevMissRatio());
    }

//getting X% most expensive methods
    public static double expensivenessThreshold(int kStdDev) {
        return getAverageExecutionTime() + (kStdDev * getStdDevExecutionTimeRatio());
    }

    public static double shareabilityThreshold(int kStdDev) {
        return getAverageShareability() + (kStdDev * getStdDevShareability());
    }

//getting X% most frenquent
    public static double frequencyThreshold(int kStdDev) {
        return getAverageFrequency() + (kStdDev * getStdDevFrequency());
    }

}
