/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.approachescomparison.adapter;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.reader.Mode;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [APLCache] %5$s %n");

        if (args.length < 2) {
            System.err.println("--trace=<TracePath> --output=<OutputPath> [--mode=<complete|hashed|partial>]");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            String[] split = arg.split("=");
            if (split.length < 2) {
                return new String[]{arg, ""};
            }
            return split;
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String tracePath = arguments.get("trace");
        if (tracePath == null) {
            System.err.println("<TracePath> is required");
            System.exit(1);
        }
        String outputPath = arguments.get("output");
        if (outputPath == null) {
            System.err.println("<OutputPath> is required");
            System.exit(1);
        }
        String mode = arguments.get("mode");
        if (mode == null) {
            mode = "complete";
            LOGGER.log(Level.INFO, "Using default mode: {0}", mode);
        }

        LOGGER.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.parseFile(tracePath, Mode.valueOf(mode.toUpperCase()));
        LOGGER.log(Level.INFO, "Grouping {0} traces by methods", traces.size());
        List<Method> methods = TraceReader.groupByMethods(traces);
        FlowchartWorkFlow flowchartWorkFlow = new FlowchartWorkFlow();
        flowchartWorkFlow.setMethods(methods);
        LOGGER.log(Level.INFO, "Filtering cacheable methods");
        flowchartWorkFlow.filterCacheableInputs();
        methods.forEach(method -> {
            System.out.println(method + " : " + method.getGroupsOfOccurrences().size() + " parameters");
        });
        try (FileWriter fileWriter = new FileWriter(outputPath)) {
            JsonObject jsonCacheableParameters = new JsonObject();
            methods.forEach(method -> {
                JsonArray cacheableParameters = new JsonArray();
                method.getGroupsOfOccurrences().forEach(group -> {
                    cacheableParameters.add(group.getParameters());
                });
                jsonCacheableParameters.add(method.getName(), cacheableParameters);
            });
            try {
                fileWriter.write(jsonCacheableParameters.toString());
            } catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "could not write to <outputPath>");
            }
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "invalid <outputPath>");
        }
    }
}
