package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

public class LogTrace {

    private MethodInfo methodInfo;
    private long startTime;
    private long endTime;
    private String userId;

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public LogTrace setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        return this;
    }

    public long totalTime() {
        return endTime - startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public LogTrace setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public LogTrace setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getUserId() {
        return userId;
    }

    public LogTrace setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogTrace)) {
            return false;
        }

        LogTrace logTrace = (LogTrace) o;

        if (endTime != logTrace.endTime) {
            return false;
        }
        if (startTime != logTrace.startTime) {
            return false;
        }
        if (methodInfo != null ? !methodInfo.equals(logTrace.methodInfo) : logTrace.methodInfo != null) {
            return false;
        }
        if (userId != null ? !userId.equals(logTrace.userId) : logTrace.userId != null) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = methodInfo != null ? methodInfo.hashCode() : 0;
        result = 31 * result + (int) (startTime ^ (startTime >>> 32));
        result = 31 * result + (int) (endTime ^ (endTime >>> 32));
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "LogTrace{"
                + "methodInfo=" + methodInfo
                + ", startTime=" + startTime
                + ", endTime=" + endTime
                + ", userId='" + userId + '\''
                + '}';
    }
}
