package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import br.ufrgs.inf.prosoft.trace.TraceConcrete;
import br.ufrgs.inf.prosoft.trace.Traces;
import java.util.stream.Collectors;

public class MethodInfoReference extends MethodInfo {

    private final int index;

    public MethodInfoReference(String signature, int index) {
        super(signature);
        this.index = index;
    }

    @Override
    public Object[] getArguments() {
        TraceConcrete traceConcrete = Traces.getTraceConcrete(index);
        return traceConcrete.getParameters().stream()
                .map(trace->trace.getData())
                .collect(Collectors.toList())
                .toArray();
    }

    @Override
    public Object getReturnedValue() {
        TraceConcrete traceConcrete = Traces.getTraceConcrete(index);
        return traceConcrete.getReturn().getData();
    }

}
