/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.approachescomparison.adapter;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.MethodInfoConcrete;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.MethodInfoReference;
import br.ufrgs.inf.prosoft.trace.Parameter;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.TraceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/**
 *
 * @author romulo
 */
public class TraceReader extends br.ufrgs.inf.prosoft.trace.TraceReader {

    private static final Logger logger = Logger.getLogger(TraceReader.class.getName());

    public static List<LogTrace> getLogTraces(List<Trace> traces) {
        logger.log(Level.INFO, "Converting {0} traces", traces.size());
        List<LogTrace> logTraces = new ArrayList<>();
        int index = 1;
        while (!traces.isEmpty()) {
            Trace trace = traces.remove(0);
            try {
                System.out.print(".");
                System.out.flush();
                if (index++ % 100 == 0) {
                    System.out.println();
                }
                LogTrace logTrace = new LogTrace().setStartTime(trace.getStartTime())
                        .setEndTime(trace.getEndTime())
                        .setUserId(trace.getUserSession());
                if (trace instanceof TraceReference) {
                    TraceReference traceReference = (TraceReference) trace;
                    logTrace.setMethodInfo(new MethodInfoReference(traceReference.getName(), traceReference.getIndex()));
                } else {
                    logTrace.setMethodInfo(new MethodInfoConcrete(trace.getName(),
                            trace.getParameters().stream().map(Parameter::getData)
                                    .collect(Collectors.toList()).toArray(),
                            trace.getReturn().getData()));
                }
                logTraces.add(logTrace);
            } catch (Exception e) {
                logger.log(Level.INFO, "Trace discarted: {0}", trace);
            }
        }
        return logTraces;
    }
}
