package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;

import java.util.Objects;
import org.ehcache.sizeof.SizeOf;

public abstract class MethodInfo {

    private final String signature;

    public MethodInfo(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public abstract Object[] getArguments();

    public abstract Object getReturnedValue();

    public long getSizeOfReturnedValue() {
        SizeOf sizeOf = SizeOf.newInstance();
        return sizeOf.sizeOf(getReturnedValue());
    }

    public boolean equalsWithoutReturnedValue(MethodInfo o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!signature.equals(o.signature)) {
            return false;
        }
        Object[] thisArguments = getArguments();
        Object[] otherArguments = o.getArguments();
        return Objects.deepEquals(thisArguments, otherArguments)
                || EqualsBuilder.reflectionEquals(thisArguments, otherArguments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MethodInfo that = (MethodInfo) o;
        if (!signature.equals(that.signature)) {
            return false;
        }
        Object[] thisArguments = getArguments();
        Object[] thatArguments = that.getArguments();
        if (!EqualsBuilder.reflectionEquals(thisArguments, thatArguments)) {
            return false;
        }
        thisArguments = null;
        thatArguments = null;
        Object thisReturnedValue = getReturnedValue();
        Object thatReturnedValue = that.getReturnedValue();
        return EqualsBuilder.reflectionEquals(thisReturnedValue, thatReturnedValue)
                || Objects.deepEquals(thisReturnedValue, thatReturnedValue);
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.MethodInfo(signature="
                + this.signature
                + ", arguments=" + Arrays.toString(getArguments())
                + ", returnedValue=" + getReturnedValue() + ")";
    }

}
