/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.approachescomparison.adapter;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [APLCache] %5$s %n");

        if (args.length < 1) {
            System.err.println("<TracePath>");
            System.exit(1);
        }
        String path = args[0];
        LOGGER.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.parseFile(path);
        LOGGER.log(Level.INFO, "Grouping {0} traces by methods", traces.size());
        List<Method> methods = TraceReader.groupByMethods(traces);
        FlowchartWorkFlow flowchartWorkFlow = new FlowchartWorkFlow();
        flowchartWorkFlow.setMethods(methods);
        LOGGER.log(Level.INFO, "Filtering cacheable methods");
        flowchartWorkFlow.filterCacheableInputs();
        methods.forEach(method -> {
            System.out.println(method + " : " + method.getGroupsOfOccurrences().size() + " parameters");
        });
        methods.forEach(method -> {
            System.out.println(method);
            method.getGroupsOfOccurrences().forEach(group -> {
                System.out.println("parameters: " + group.getParameters());
                System.out.println("stats: " + group.getMetrics());
                System.out.println();
            });
            System.out.println();
        });
    }
}
