/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.aplcache;

import br.ufrgs.inf.prosoft.aplcache.adapter.TraceReader;
import br.ufrgs.inf.prosoft.aplcache.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.aplcache.metadata.Method;
import br.ufrgs.inf.prosoft.trace.Trace;
import br.ufrgs.inf.prosoft.trace.reader.Mode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [APLCache] %5$s %n");

        if (args.length < 2) {
            System.err.println("--trace=<TracePath> --output=<OutputPath> [--mode=<complete|hashed|partial>] [--k=<kStandardDeviation>]");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String tracePath = arguments.get("trace");
        if (tracePath == null) {
            System.err.println("<TracePath> is required");
            System.exit(1);
        }
        String outputPath = arguments.get("output");
        if (outputPath == null) {
            System.err.println("<OutputPath> is required");
            System.exit(1);
        }
        String mode = arguments.get("mode");
        if (mode == null) {
            mode = "complete";
            LOGGER.log(Level.INFO, "Using default mode: {0}", mode);
        }
        int k = 0;
        String kStr = arguments.get("k");
        if (kStr == null) {
            LOGGER.log(Level.INFO, "Using default k: {0}", k);
        } else {
            try {
                k = Integer.valueOf(kStr);
            } catch (NumberFormatException ex) {
                System.err.println("<k> must be a number");
                System.exit(1);
            }
        }

        LOGGER.log(Level.INFO, "Reading traces");
        List<Trace> traces = TraceReader.parseFile(tracePath, Mode.valueOf(mode.toUpperCase()));
        LOGGER.log(Level.INFO, "Grouping {0} traces by methods", traces.size());
        List<Method> methods = TraceReader.groupByMethods(traces);
        FlowchartWorkFlow flowchartWorkFlow = new FlowchartWorkFlow();
        flowchartWorkFlow.setMethods(methods);
        LOGGER.log(Level.INFO, "Filtering cacheable methods");
        flowchartWorkFlow.filterCacheableInputs(k);
        methods.forEach(method -> {
            System.out.println(method + " : " + method.getGroupsOfOccurrences().size() + " parameters");
        });
        try (FileWriter fileWriter = new FileWriter(outputPath)) {
            JsonObject jsonCacheableParameters = new JsonObject();
            methods.forEach(method -> {
                JsonArray cacheableParameters = new JsonArray();
                method.getGroupsOfOccurrences().forEach(group -> {
                    cacheableParameters.add(group.getParameters());
                });
                jsonCacheableParameters.add(method.getName(), cacheableParameters);
            });
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(jsonCacheableParameters, fileWriter);
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "invalid <outputPath>");
        }
    }
}
