/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.killbill.billing.util.config;

import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.Description;

public interface OSGIConfig extends KillbillConfig {

    @Config("org.killbill.osgi.bundle.property.name")
    @Default("killbill.properties")
    @Description("Name of the properties file for OSGI plugins")
    public String getOSGIKillbillPropertyName();

    @Config("org.killbill.osgi.root.dir")
    @Default("/var/tmp/felix")
    @Description("Bundles cache area for the OSGI framework")
    public String getOSGIBundleRootDir();

    @Config("org.killbill.osgi.bundle.cache.name")
    @Default("osgi-cache")
    @Description("Bundles cache name")
    public String getOSGIBundleCacheName();

    @Config("org.killbill.osgi.bundle.install.dir")
    @Default("/var/tmp/bundles")
    @Description("Bundles install directory")
    public String getRootInstallationDir();

    @Config("org.killbill.osgi.system.bundle.export.packages")
    @Default("org.killbill.billing.account.api," +
             "org.killbill.billing.analytics.api.sanity," +
             "org.killbill.billing.analytics.api.user," +
             "org.killbill.billing.beatrix.bus.api," + /* TODO PIERRE Remove it after plugins classes have been regenerated */
             "org.killbill.billing.catalog.api," +
             "org.killbill.billing.invoice.api," +
             "org.killbill.billing.entitlement.api," +
             "org.killbill.billing," +
             "org.killbill.billing.notification.api," +
             "org.killbill.billing.notification.plugin.api," +
             "org.killbill.billing.osgi.api," +
             "org.killbill.billing.osgi.api.config," +
             "org.killbill.billing.overdue," +
             "org.killbill.billing.payment.api," +
             "org.killbill.billing.payment.plugin.api," +
             "org.killbill.billing.tenant.api," +
             "org.killbill.billing.usage.api," +
             "org.killbill.billing.util.config," +
             "org.killbill.billing.util.api," +
             "org.killbill.billing.util.audit," +
             "org.killbill.billing.util.callcontext," +
             "org.killbill.billing.util.customfield," +
             "org.killbill.billing.notification.plugin," +
             "org.killbill.billing.currency.plugin.api," +
             "org.killbill.billing.currency.api," +
             "org.killbill.billing.util.email," +
             "org.killbill.billing.util.entity," +
             "org.killbill.billing.util.tag," +
             "org.killbill.billing.util.template," +
             "org.killbill.billing.util.template.translation," +
             // javax.servlet and javax.servlet.http are not exported by default - we
             // need the bundles to see them for them to be able to register their servlets.
             // Note: bundles should mark javax.servlet:servlet-api as provided
             "sun.misc," +
             "sun.misc.unsafe," +
             "javax.crypto," +
             "javax.crypto.spec," +
             "javax.management," +
             "javax.servlet;version=3.0," +
             "javax.servlet.http;version=3.0," +
             // Since we are using joda in our APIs we need to export it
             "org.joda.time;org.joda.time.format;version=2.3," +
             // KillbillConfigSource is exported and implements ConfigSource so that needs to be exported
             "org.skife.config;org.skife.config.cglib.asm;org.skife.config.cglib.beans;org.skife.config.cglib.core;org.skife.config.cglib.proxy;org.skife.config.cglib.reflect;org.skife.config.cglib.transform;org.skife.config.cglib.transform.impl;org.skife.config.cglib.util," +
             "org.osgi.service.log;version=1.3," +
             // Let the world know the System bundle exposes (via org.osgi.compendium) the requirement (osgi.wiring.package=org.osgi.service.http)
             "org.osgi.service.http;version=1.2.0," +
             // Let the world know the System bundle exposes (via org.osgi.compendium) the requirement (&(osgi.wiring.package=org.osgi.service.deploymentadmin)(version>=1.1.0)(!(version>=2.0.0)))
             "org.osgi.service.deploymentadmin;version=1.1.0," +
             // Let the world know the System bundle exposes (via org.osgi.compendium) the requirement (&(osgi.wiring.package=org.osgi.service.event)(version>=1.2.0)(!(version>=2.0.0)))
             "org.osgi.service.event;version=1.2.0," +
             // Let the world know the System bundle exposes the requirement (&(osgi.wiring.package=org.slf4j)(version>=1.7.0)(!(version>=2.0.0)))
             "org.slf4j;version=1.7.2")
    @Description("Packages to export from the system bundle")
    public String getSystemBundleExportPackages();
}
