module ActiveMerchant #:nodoc:
  module Billing #:nodoc:
    module Integrations #:nodoc:
      class Return
        attr_accessor :params
        attr_reader :notification
      
        def initialize(query_string, options = {})
          @params  = parse(query_string)
          @options = options
        end
      
        # Successful by default. Overridden in the child class
        def success?
          true
        end

        # Not cancelled by default.  Overridden in the child class.
        def cancelled?
          false
        end

        def message
          
        end
        
        def parse(query_string)
          return {} if query_string.blank?
          
          query_string.split('&').inject({}) do |memo, chunk|
            next if chunk.empty?
            key, value = chunk.split('=', 2)
            next if key.empty?
            value = value.nil? ? nil : CGI.unescape(value)
            memo[CGI.unescape(key)] = value
            memo
          end
        end 
      end
    end
  end
end
