/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.util.config;

import org.skife.config.Config;
import org.skife.config.Default;

public interface OSGIConfig extends KillbillConfig {

    @Config("killbill.osgi.root.dir")
    @Default("/var/tmp/felix")
    public String getOSGIBundleRootDir();

    @Config("killbill.osgi.bundle.cache.name")
    @Default("osgi-cache")
    public String getOSGIBundleCacheName();

    @Config("killbill.osgi.bundle.install.dir")
    @Default("/var/tmp/bundles")
    public String getRootInstallationDir();

    @Config("killbill.osgi.system.bundle.export.packages")
    @Default("com.ning.billing.account.api," +
             "com.ning.billing.analytics.api.sanity," +
             "com.ning.billing.analytics.api.user," +
             "com.ning.billing.beatrix.bus.api," +
             "com.ning.billing.catalog.api," +
             "com.ning.billing.entitlement.api.migration," +
             "com.ning.billing.entitlement.api.timeline," +
             "com.ning.billing.entitlement.api.transfer," +
             "com.ning.billing.entitlement.api.user," +
             "com.ning.billing.invoice.api," +
             "com.ning.billing.osgi.api," +
             "com.ning.billing.osgi.api.config," +
             "com.ning.billing.overdue," +
             "com.ning.billing.payment.api," +
             "com.ning.billing.tenant.api," +
             "com.ning.billing.usage.api," +
             "com.ning.billing.util.api," +
             "com.ning.billing.util.callcontext," +
             "com.google.common.eventbus," +
             "org.osgi.service.log")
    public String getSystemBundleExportPackages();

    // TODO FIXME OSGI
    @Config("killbill.osgi.jruby.bundle.path")
    @Default("file:/var/tmp/killbill-osgi-bundles-jruby-0.1.52-SNAPSHOT-jar-with-dependencies.jar")
    public String getJrubyBundlePath();

}
