/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.entitlement;

import java.net.URL;

import javax.inject.Inject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

import com.ning.billing.GuicyKillbillTestSuiteNoDB;
import com.ning.billing.account.api.AccountData;
import com.ning.billing.api.TestApiListener;
import com.ning.billing.api.TestListenerStatus;
import com.ning.billing.catalog.api.Catalog;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.clock.ClockMock;
import com.ning.billing.entitlement.api.SubscriptionService;
import com.ning.billing.entitlement.api.migration.EntitlementMigrationApi;
import com.ning.billing.entitlement.api.user.TestEntitlementHelper;
import com.ning.billing.entitlement.engine.dao.EntitlementDao;
import com.ning.billing.entitlement.engine.dao.MockEntitlementDaoMemory;
import com.ning.billing.entitlement.glue.TestEngineModuleNoDB;
import com.ning.billing.subscription.api.timeline.SubscriptionTimelineApi;
import com.ning.billing.subscription.api.transfer.SubscriptionTransferApi;
import com.ning.billing.subscription.api.user.SubscriptionBundle;
import com.ning.billing.subscription.api.user.SubscriptionUserApi;
import com.ning.billing.util.config.EntitlementConfig;
import com.ning.billing.util.svcapi.entitlement.EntitlementInternalApi;
import com.ning.billing.util.svcsapi.bus.BusService;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Stage;

public class EntitlementTestSuiteNoDB extends GuicyKillbillTestSuiteNoDB {

    protected static final Logger log = LoggerFactory.getLogger(EntitlementTestSuiteNoDB.class);

    @Inject
    protected SubscriptionService entitlementService;
    @Inject
    protected SubscriptionUserApi entitlementApi;
    @Inject
    protected EntitlementInternalApi entitlementInternalApi;
    @Inject
    protected SubscriptionTransferApi transferApi;

    @Inject
    protected EntitlementMigrationApi migrationApi;
    @Inject
    protected SubscriptionTimelineApi repairApi;

    @Inject
    protected CatalogService catalogService;
    @Inject
    protected EntitlementConfig config;
    @Inject
    protected EntitlementDao dao;
    @Inject
    protected ClockMock clock;
    @Inject
    protected BusService busService;

    @Inject
    protected TestEntitlementHelper testUtil;
    @Inject
    protected TestApiListener testListener;
    @Inject
    protected TestListenerStatus testListenerStatus;

    @Inject
    protected EntitlementTestInitializer entitlementTestInitializer;

    protected Catalog catalog;
    protected AccountData accountData;
    protected SubscriptionBundle bundle;

    private void loadSystemPropertiesFromClasspath(final String resource) {
        final URL url = DefaultEntitlementTestInitializer.class.getResource(resource);
        Assert.assertNotNull(url);

        configSource.merge(url);
    }

    @BeforeClass(groups = "fast")
    public void beforeClass() throws Exception {
        loadSystemPropertiesFromClasspath("/entitlement.properties");

        final Injector g = Guice.createInjector(Stage.PRODUCTION, new TestEngineModuleNoDB(configSource));
        g.injectMembers(this);
    }

    @BeforeMethod(groups = "fast")
    public void beforeMethod() throws Exception {

        // CLEANUP ALL DB TABLES OR IN MEMORY STRUCTURES
        ((MockEntitlementDaoMemory) dao).reset();

        entitlementTestInitializer.startTestFamework(testListener, testListenerStatus, clock, busService, entitlementService);

        this.catalog = entitlementTestInitializer.initCatalog(catalogService);
        this.accountData = entitlementTestInitializer.initAccountData();
        this.bundle = entitlementTestInitializer.initBundle(entitlementApi, callContext);
    }

    @AfterMethod(groups = "fast")
    public void afterMethod() throws Exception {
        entitlementTestInitializer.stopTestFramework(testListener, busService, entitlementService);
    }

    protected void assertListenerStatus() {
        ((EntitlementTestListenerStatus) testListenerStatus).assertListenerStatus();
    }
}
