/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.jaxrs.json;

import com.ning.billing.account.api.BillCycleDay;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class BillCycleDayJson {

    private final int dayOfMonthLocal;
    private final int dayOfMonthUTC;

    @JsonCreator
    public BillCycleDayJson(@JsonProperty("dayOfMonthLocal") final int dayOfMonthLocal,
                            @JsonProperty("dayOfMonthUTC") final int dayOfMonthUTC) {
        this.dayOfMonthLocal = dayOfMonthLocal;
        this.dayOfMonthUTC = dayOfMonthUTC;
    }

    public BillCycleDayJson(final BillCycleDay billCycleDay) {
        this(billCycleDay.getDayOfMonthLocal(), billCycleDay.getDayOfMonthUTC());
    }

    public int getDayOfMonthUTC() {
        return dayOfMonthUTC;
    }

    public int getDayOfMonthLocal() {
        return dayOfMonthLocal;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("{\"dayOfMonthLocal\":").append(dayOfMonthLocal);
        sb.append(",\"dayOfMonthUTC\":").append(dayOfMonthUTC);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final BillCycleDayJson that = (BillCycleDayJson) o;

        if (dayOfMonthLocal != that.dayOfMonthLocal) return false;
        if (dayOfMonthUTC != that.dayOfMonthUTC) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = dayOfMonthLocal;
        result = 31 * result + dayOfMonthUTC;
        return result;
    }
}
