/*
 * Copyright 2010-2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.ning.billing.mock.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.joda.time.DateTime;

import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.entitlement.api.BlockingState;
import com.ning.billing.overdue.OverdueState;
import com.ning.billing.subscription.api.user.Subscription;
import com.ning.billing.subscription.api.user.SubscriptionBundle;
import com.ning.billing.subscription.api.user.SubscriptionStatusDryRun;
import com.ning.billing.subscription.api.user.SubscriptionUserApi;
import com.ning.billing.subscription.api.user.SubscriptionUserApiException;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.callcontext.TenantContext;

public class MockSubscriptionUserApi implements SubscriptionUserApi {

    private final Map<UUID, String> subscriptionBundles = new HashMap<UUID, String>();
    private final Map<UUID, UUID> accountForBundle = new HashMap<UUID, UUID>();
    private final Map<UUID, Subscription> subscriptionsById = new HashMap<UUID, Subscription>();

    public synchronized void addBundle(final UUID bundleUUID, final String externalKey, final UUID accountId) {
        subscriptionBundles.put(bundleUUID, externalKey);
        accountForBundle.put(bundleUUID, accountId);
    }

    @Override
    public SubscriptionBundle getBundleFromId(final UUID id, final TenantContext context) {
        final String key = subscriptionBundles.get(id);
        if (key == null) {
            return null;
        }

        return new SubscriptionBundle() {
            @Override
            public UUID getAccountId() {
                return accountForBundle.get(id);
            }

            @Override
            public UUID getId() {
                return id;
            }

            @Override
            public DateTime getCreatedDate() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DateTime getUpdatedDate() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getExternalKey() {
                return key;
            }

            @Override
            public OverdueState<SubscriptionBundle> getOverdueState() {
                throw new UnsupportedOperationException();
            }

            @Override
            public BlockingState getBlockingState() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Subscription getSubscriptionFromId(final UUID id, final TenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubscriptionBundle> getBundlesForAccount(final UUID accountId, final TenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubscriptionBundle> getBundlesForKey(final String bundleKey, final TenantContext context)
            throws SubscriptionUserApiException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Subscription> getSubscriptionsForBundle(final UUID bundleId, final TenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SubscriptionBundle createBundleForAccount(final UUID accountId, final String bundleKey, final CallContext context) throws SubscriptionUserApiException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Subscription> getSubscriptionsForAccountAndKey(final UUID accountId, final String bundleKey, final TenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Subscription createSubscription(final UUID bundleId, final PlanPhaseSpecifier spec,
                                           final DateTime requestedDate, final CallContext context) throws SubscriptionUserApiException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SubscriptionBundle getBundleForAccountAndKey(final UUID accountId, final String bundleKey, final TenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DateTime getNextBillingDate(final UUID account, final TenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Subscription getBaseSubscription(final UUID bundleId, final TenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SubscriptionStatusDryRun> getDryRunChangePlanStatus(final UUID subscriptionId, final String productName, final DateTime requestedDate, final TenantContext context)
            throws SubscriptionUserApiException {
        throw new UnsupportedOperationException();
    }
}
