package com.ning.billing.util.security;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.lang.annotation.Annotation;

import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;

import com.ning.billing.security.Permission;
import com.ning.billing.security.RequiresPermissions;
import com.ning.billing.security.SecurityApiException;
import com.ning.billing.security.api.SecurityApi;
import com.ning.billing.util.callcontext.DefaultTenantContext;
import com.ning.billing.util.callcontext.TenantContext;

import com.google.common.collect.ImmutableList;

public class PermissionAnnotationHandler extends AuthorizingAnnotationHandler {

    private final TenantContext context = new DefaultTenantContext(null);
    private final SecurityApi securityApi;

    public PermissionAnnotationHandler(final SecurityApi securityApi) {
        super(RequiresPermissions.class);
        this.securityApi = securityApi;
    }

    public void assertAuthorized(final Annotation annotation) throws AuthorizationException {
        if (!(annotation instanceof RequiresPermissions)) {
            return;
        }

        final RequiresPermissions requiresPermissions = (RequiresPermissions) annotation;
        try {
            securityApi.checkCurrentUserPermissions(ImmutableList.<Permission>copyOf(requiresPermissions.value()), requiresPermissions.logical(), context);
        } catch (SecurityApiException e) {
            if (e.getCause() != null && e.getCause() instanceof AuthorizationException) {
                throw (AuthorizationException) e.getCause();
            } else if (e.getCause() != null) {
                throw new AuthorizationException(e.getCause());
            } else {
                throw new AuthorizationException(e);
            }
        }
    }
}
