###################################################################################
#                                                                                 #
#                   Copyright 2010-2013 Ning, Inc.                                #
#                                                                                 #
#      Ning licenses this file to you under the Apache License, version 2.0       #
#      (the "License"); you may not use this file except in compliance with the   #
#      License.  You may obtain a copy of the License at:                         #
#                                                                                 #
#          http://www.apache.org/licenses/LICENSE-2.0                             #
#                                                                                 #
#      Unless required by applicable law or agreed to in writing, software        #
#      distributed under the License is distributed on an "AS IS" BASIS, WITHOUT  #
#      WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  #
#      License for the specific language governing permissions and limitations    #
#      under the License.                                                         #
#                                                                                 #
###################################################################################


#
#                       DO NOT EDIT!!!
#    File automatically generated by killbill-java-parser (git@github.com:killbill/killbill-java-parser.git)
#


module Killbill
  module Plugin
    module Api

      java_package 'org.killbill.billing.util.api'
      class CustomFieldUserApi

        include org.killbill.billing.util.api.CustomFieldUserApi

        def initialize(real_java_api)
          @real_java_api = real_java_api
        end


        java_signature 'Java::org.killbill.billing.util.entity.Pagination searchCustomFields(Java::java.lang.String, Java::java.lang.Long, Java::java.lang.Long, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def search_custom_fields(searchKey, offset, limit, context)

          # conversion for searchKey [type = java.lang.String]
          searchKey = searchKey.to_s unless searchKey.nil?

          # conversion for offset [type = java.lang.Long]
          offset = offset

          # conversion for limit [type = java.lang.Long]
          limit = limit

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.search_custom_fields(searchKey, offset, limit, context)
          # conversion for res [type = org.killbill.billing.util.entity.Pagination]
          res = Killbill::Plugin::Model::Pagination.new.to_ruby(res) unless res.nil?
          return res
        end

        java_signature 'Java::org.killbill.billing.util.entity.Pagination getCustomFields(Java::java.lang.Long, Java::java.lang.Long, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_custom_fields(offset, limit, context)

          # conversion for offset [type = java.lang.Long]
          offset = offset

          # conversion for limit [type = java.lang.Long]
          limit = limit

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.get_custom_fields(offset, limit, context)
          # conversion for res [type = org.killbill.billing.util.entity.Pagination]
          res = Killbill::Plugin::Model::Pagination.new.to_ruby(res) unless res.nil?
          return res
        end

        java_signature 'Java::void addCustomFields(Java::java.util.List, Java::org.killbill.billing.util.callcontext.CallContext)'
        def add_custom_fields(fields, context)

          # conversion for fields [type = java.util.List]
          tmp = java.util.ArrayList.new
          (fields || []).each do |m|
            # conversion for m [type = org.killbill.billing.util.customfield.CustomField]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          fields = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          @real_java_api.add_custom_fields(fields, context)
        end

        java_signature 'Java::void removeCustomFields(Java::java.util.List, Java::org.killbill.billing.util.callcontext.CallContext)'
        def remove_custom_fields(fields, context)

          # conversion for fields [type = java.util.List]
          tmp = java.util.ArrayList.new
          (fields || []).each do |m|
            # conversion for m [type = org.killbill.billing.util.customfield.CustomField]
            m = m.to_java unless m.nil?
            tmp.add(m)
          end
          fields = tmp

          # conversion for context [type = org.killbill.billing.util.callcontext.CallContext]
          context = context.to_java unless context.nil?
          @real_java_api.remove_custom_fields(fields, context)
        end

        java_signature 'Java::java.util.List getCustomFieldsForObject(Java::java.util.UUID, Java::org.killbill.billing.ObjectType, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_custom_fields_for_object(objectId, objectType, context)

          # conversion for objectId [type = java.util.UUID]
          objectId = java.util.UUID.fromString(objectId.to_s) unless objectId.nil?

          # conversion for objectType [type = org.killbill.billing.ObjectType]
          objectType = Java::org.killbill.billing.ObjectType.value_of("#{objectType.to_s}") unless objectType.nil?

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.get_custom_fields_for_object(objectId, objectType, context)
          # conversion for res [type = java.util.List]
          tmp = []
          (res || []).each do |m|
            # conversion for m [type = org.killbill.billing.util.customfield.CustomField]
            m = Killbill::Plugin::Model::CustomField.new.to_ruby(m) unless m.nil?
            tmp << m
          end
          res = tmp
          return res
        end

        java_signature 'Java::java.util.List getCustomFieldsForAccountType(Java::java.util.UUID, Java::org.killbill.billing.ObjectType, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_custom_fields_for_account_type(accountId, objectType, context)

          # conversion for accountId [type = java.util.UUID]
          accountId = java.util.UUID.fromString(accountId.to_s) unless accountId.nil?

          # conversion for objectType [type = org.killbill.billing.ObjectType]
          objectType = Java::org.killbill.billing.ObjectType.value_of("#{objectType.to_s}") unless objectType.nil?

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.get_custom_fields_for_account_type(accountId, objectType, context)
          # conversion for res [type = java.util.List]
          tmp = []
          (res || []).each do |m|
            # conversion for m [type = org.killbill.billing.util.customfield.CustomField]
            m = Killbill::Plugin::Model::CustomField.new.to_ruby(m) unless m.nil?
            tmp << m
          end
          res = tmp
          return res
        end

        java_signature 'Java::java.util.List getCustomFieldsForAccount(Java::java.util.UUID, Java::org.killbill.billing.util.callcontext.TenantContext)'
        def get_custom_fields_for_account(accountId, context)

          # conversion for accountId [type = java.util.UUID]
          accountId = java.util.UUID.fromString(accountId.to_s) unless accountId.nil?

          # conversion for context [type = org.killbill.billing.util.callcontext.TenantContext]
          context = context.to_java unless context.nil?
          res = @real_java_api.get_custom_fields_for_account(accountId, context)
          # conversion for res [type = java.util.List]
          tmp = []
          (res || []).each do |m|
            # conversion for m [type = org.killbill.billing.util.customfield.CustomField]
            m = Killbill::Plugin::Model::CustomField.new.to_ruby(m) unless m.nil?
            tmp << m
          end
          res = tmp
          return res
        end
      end
    end
  end
end
