/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.remoteexecutor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class Server {

    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());

    public static void listen(File home, int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            LOGGER.log(Level.INFO, "start listening on port " + port);
            boolean exit = false;
            while (!exit) {
                Socket socket = null;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    socket = serverSocket.accept();
                    inputStream = socket.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String message = bufferedReader.readLine();
                    if (message == null) {
                        message = "";
                    }
                    LOGGER.log(Level.INFO, "> {0}", message);
                    if (message.startsWith("caching-approaches-comparison ")) {
                        String command = message.replaceFirst("caching-approaches-comparison ", "");
                        if (command.equals("exit")) {
                            exit = true;
                        } else {
                            try {
                                ProcessBuilder processBuilder = new ProcessBuilder();
                                processBuilder.directory(home);
                                String[] commandArray = command.split(" ");
                                List<String> commandList = Arrays.asList(commandArray);
                                if (commandList.get(0).contains("=")) {
                                    String[] map = commandList.get(0).split("=");
                                    processBuilder.environment().put(map[0], map[1]);
                                    commandList = commandList.subList(1, commandList.size());
                                }
                                processBuilder.command(commandList);
                                processBuilder.inheritIO();
                                processBuilder.start();
                            } catch (Exception ex) {
                                LOGGER.log(Level.WARNING, ex.getMessage());
                                message = "command failed";
                            }
                        }
                    }
                    message = "[RemoteExecutor] " + message;
                    LOGGER.log(Level.INFO, "< {0}", message);
                    message += "\n";
                    outputStream = socket.getOutputStream();
                    outputStream.write(message.getBytes());
                } catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "connection closed before echo is sent");
                } catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "exception: {0}", ex);
                } finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        } catch (IOException ex) {
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        } catch (IOException ex) {
                        }
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        } catch (IOException ex) {
                        }
                    }
                }
            }
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "port " + port + " is busy");
        } finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                } catch (IOException ex) {
                }
            }
        }
    }
}
