/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.remoteexecutor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author romulo
 */
public class Client {

    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());

    public static int send(String message, String host, int port) {
        Socket socket = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        int signal = 0;
        try {
            socket = new Socket(host, port);
            outputStream = socket.getOutputStream();
            LOGGER.log(Level.INFO, "< {0}", message);
            message += "\n";
            outputStream.write(message.getBytes());
            inputStream = socket.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String response = bufferedReader.readLine();
            LOGGER.log(Level.INFO, "> {0}", response);
        } catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "could not connect to {0}:" + port, host);
            signal = 1;
        } catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "exception: {0}", ex);
            signal = 2;
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException ex) {
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException ex) {
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                } catch (IOException ex) {
                }
            }
        }
        return signal;
    }
}
