/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package br.ufrgs.inf.prosoft.remoteexecutor;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author romulo
 */
public class Main {

    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT+%1$tL] [%4$-7s] [RemoteExecutor] %5$s %n");

        if (args.length < 1) {
            System.err.println("[--listen=<port> | --home=<homePath>]");
            System.err.println("--send=<message> [--host=<host>] [--port=<port>]");
            System.exit(1);
        }

        Map<String, String> arguments = Stream.of(args).map(arg -> {
            arg = arg.replaceFirst("--", "");
            int indexOf = arg.indexOf("=");
            if (indexOf == -1) {
                return new String[]{arg, ""};
            }
            return new String[]{arg.substring(0, indexOf), arg.substring(indexOf + 1)};
        }).collect(Collectors.toMap(array -> {
            return array[0];
        }, array -> {
            return array[1];
        }));

        String listen = arguments.get("listen");
        String homePath = arguments.get("home");
        String send = arguments.get("send");
        if (listen == null && homePath == null && send == null) {
            System.err.println("[--listen=<port> | --home=<homePath>]");
            System.err.println("--send=<message> [--host=<host>] [--port=<port>]");
            System.exit(1);
        }

        int port = 5000;
        if (send != null) {
            String host = arguments.get("host");
            String portStr = arguments.get("port");
            if (host == null) {
                host = "localhost";
                LOGGER.log(Level.INFO, "<host> not defined. Using {0}", host);
            }
            if (portStr == null) {
                LOGGER.log(Level.INFO, "<port> not defined. Using " + port);
            } else {
                try {
                    port = Integer.valueOf(portStr);
                } catch (NumberFormatException ex) {
                    LOGGER.log(Level.INFO, "<port> incorrectly defined. Using default: " + port);
                }
            }
            int signal = Client.send(send, host, port);
            System.exit(signal);
        }

        if (homePath == null) {
            homePath = ".";
            LOGGER.log(Level.INFO, "<home> not defined. Using default: {0}", homePath);
        }

        if (listen == null) {
            LOGGER.log(Level.INFO, "<port> not defined. Using " + port);
        }

        File home = new File(homePath);
        Server.listen(home, port);
    }
}
