#!/bin/bash

if [ "$(whoami)" != 'root' ]; then
    echo "You have no permission to run $0 as non-root user."
    exit 1;
fi

export JAVA_HOME=/usr/lib/jvm/java-8-oracle
export JAVA_OPTS="-Xms4096m -Xmx6124m"

host="localhost"
applications=$(echo applications/uncached/*/)
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		applications=$2
	fi
fi

echo "Running in host $host for the applications: $applications"
for application in $applications; do
	application=${application%/}
	if [[ $host = "localhost" ]]; then
		docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build
	else
		echo "caching-approaches-comparison docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build" | netcat -w0 $host 5000
	fi
	bash -c 'while ! curl -s '$host:8080' > /dev/null; do sleep 5; done'
	java -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --time=3600000 --users=1 --log=applications/workloads/$application-execution-uncached.json --throughput=applications/output/$application-uncached-requests > applications/output/$application-uncached-simulator.log 2>&1
	if [[ $host = "localhost" ]]; then
		docker-compose -f applications/uncached/$application/docker-compose.yml down -v
	else
		echo "caching-approaches-comparison docker-compose -f applications/uncached/$application/docker-compose.yml down -v" | netcat -w0 $host 5000
		sleep 11
	fi
done