#!/bin/bash

if [ "$(whoami)" != 'root' ]; then
	echo "You have no permission to run $0 as non-root user."
	exit 1;
fi

export JAVA_OPTS=${JAVA_OPTS:-"-Xmx7500m"}
JAVA_SERVER_OPTS=${JAVA_SERVER_OPTS:-"-Xmx30000m"}

host="localhost"
versions="uncached developers aplcache memoizeit"
applications=$(echo applications/uncached/*/)
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		versions=$2
		if [[ ! -z $3 ]]; then
			applications=$3
		fi
	fi
fi

echo "$(date '+%F %T') Executing workloads in host $host for the applications $applications among the versions $versions"
for application in $applications; do
	application=${application%/}
	for user in 25 5 1; do
		for version in $versions; do
			version=${version%/}
			echo "$(date '+%F %T')  Sampling $application with $user users in $version version"
			for execution in {1..10}; do
				if [[ ! -f applications/workloads/$application-workload-${user}user.json ]]; then
					echo "$(date '+%F %T')    Generating workload for $application with $user users"
					if [[ $host = "localhost" ]]; then
						export TRACER_ENABLE=false
						docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build
					else
						command="JAVA_OPTS=$JAVA_SERVER_OPTS TRACER_ENABLE=false docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build"
						while ! java -jar adapters/RemoteExecutor/target/RemoteExecutor-1.0.jar --send="caching-approaches-comparison $command" --host=$host --port=5000; do sleep 5; done
					fi
					while ! curl -s $host:8080 > /dev/null; do sleep 5; done
					java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --time=600000 --users=$user --log=applications/workloads/$application-workload-${user}user.json --throughput=applications/output/$application-workload-${user}user-requests --host=$host > applications/output/$application-workload-${user}user-simulator.log 2>&1
					if [[ $host = "localhost" ]]; then
						docker-compose -f applications/uncached/$application/docker-compose.yml down -v
					else
						command="docker-compose -f applications/uncached/$application/docker-compose.yml down -v"
						while ! java -jar adapters/RemoteExecutor/target/RemoteExecutor-1.0.jar --send="caching-approaches-comparison $command" --host=$host --port=5000; do sleep 5; done
						sleep 30
					fi
				fi
				if [[ -f applications/output/$application-$version-${user}user-${execution}execution-requests ]]; then
					echo "$(date '+%F %T')   Skipping $application with $user users and execution $execution"
				else
					echo "$(date '+%F %T')   Running $application with $user users and execution $execution"
					if [[ $host = "localhost" ]]; then
						export TRACER_ENABLE=false
						export CACHE_EVENTS=/caching-approaches-comparison/applications/output/$application-$version-${user}user-${execution}execution-cache
						docker-compose -f applications/$version/$application/docker-compose.yml up -d --build
					else
						command="JAVA_OPTS=$JAVA_SERVER_OPTS TRACER_ENABLE=false CACHE_EVENTS=/caching-approaches-comparison/applications/output/$application-$version-${user}user-${execution}execution-cache docker-compose -f applications/$version/$application/docker-compose.yml up -d --build"
						while ! java -jar adapters/RemoteExecutor/target/RemoteExecutor-1.0.jar --send="caching-approaches-comparison $command" --host=$host --port=5000; do sleep 5; done
					fi
					while ! curl -s $host:8080 > /dev/null; do sleep 5; done
					timeout 1200 java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --execute=applications/workloads/$application-workload-${user}user.json --throughput=applications/output/$application-$version-${user}user-${execution}execution-requests --host=$host > applications/output/$application-$version-${user}user-${execution}execution-simulator.log 2>&1
					if [[ $host = "localhost" ]]; then
						docker-compose -f applications/$version/$application/docker-compose.yml down -v
					else
						command="docker-compose -f applications/$version/$application/docker-compose.yml down -v"
						while ! java -jar adapters/RemoteExecutor/target/RemoteExecutor-1.0.jar --send="caching-approaches-comparison $command" --host=$host --port=5000; do sleep 5; done
						sleep 30
					fi
				fi
			done
		done
	done
done
