#!/bin/bash

source functions.sh

function initialize-output() {
	reduce="$1"
	overwrite="$2"
	if [[ "$reduce" = "*" || "$reduce" = "requests" ]]; then
		if [[ ! -f  applications/output/requests-handled.csv || "$overwrite" == "overwrite" ]]; then
			echo 'application,version,group,users,execution,time,requests' > applications/output/requests-handled.csv
		fi
	fi
	if [[ "$reduce" = "*" || "$reduce" = "cache" ]]; then
		if [[ ! -f  applications/output/hits-distribution.csv || "$overwrite" == "overwrite" ]]; then
			echo 'application,version,group,users,name,identifier,event,amount' > applications/output/hits-distribution.csv
		fi
		if [[ ! -f  applications/output/uncached-parameters.csv || "$overwrite" == "overwrite" ]]; then
			echo 'application,version,group,users,name,parameters,amount' > applications/output/uncached-parameters.csv
		fi
		if [[ ! -f  applications/output/cache-size-distribution.csv || "$overwrite" == "overwrite" ]]; then
			echo 'application,version,group,users,name,time,size' > applications/output/cache-size-distribution.csv
		fi
		if [[ ! -f  applications/output/cache-stptic.csv || "$overwrite" == "overwrite" ]]; then
			echo 'application,version,group,users,name,avgexecution,ttl,additions,hits,savedtime,timeincache' > applications/output/cache-stptic.csv
		fi
	fi
}

if [ "$(whoami)" != 'root' ]; then
    echo "You have no permission to run $0 as non-root user."
    exit 1;
fi

JAVA_OPTS=${JAVA_OPTS:-"-Xms4096m -Xmx6124m"}

host="localhost"
groups="aplcache memoizeit"
applications="*"
reduce="*"
overwrite="false"
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		groups=$2
		if [[ ! -z $3 ]]; then
			applications=$3
			if [[ ! -z $4 ]]; then
				reduce=$4
				if [[ ! -z $5 ]]; then
					overwrite=$5
				fi
			fi
		fi
	fi
fi

if [[ $host = "localhost" ]]; then
	initialize-output "$reduce" "$overwrite"
elif [[ $reduce = "*" || $reduce = "cache" ]]; then
	initialize-output "requests" "$overwrite"
	command="bash reduce.sh localhost \"$groups\" \"$applications\" cache $overwrite"
	execute "$host" "$command"
fi
echo "$(date '+%F %T') Reducing $reduce in host $host for the applications $applications among the versions $versions"
for group in $groups; do
	versions=$(echo applications/$group/*/)
	for version in $versions; do
		version=${version//applications\/$group\//}
		version=${version%/}
		if [[ $applications = "*" ]]; then
			existing_applications=$(echo applications/$group/$version/*/)
		else
			existing_applications=$applications
		fi
		for application in $existing_applications; do
			application=${application//applications\/$group\/$version\//}
			application=${application%/}
			for user in 1 5 25; do
				if [[ "$reduce" = "*" || "$reduce" = "requests" ]]; then
					for execution in {1..10}; do
						echo "$(date '+%F %T')  Reducing requests of $application-$version with $user users and execution $execution"
						java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --throughput=applications/output/$application-$version-${user}user-${execution}execution-requests --reduce=applications/output/requests-handled.csv --prefix=$application,$version,$group,$user,$execution,
					done
				fi
				if [[ $host = "localhost" && ("$reduce" = "*" || "$reduce" = "cache") ]]; then
					echo "$(date '+%F %T') Reducing cachemetrics of $application-$version with $user users"
					java $JAVA_OPTS -jar adapters/Cache/target/Cache-1.0.jar --events=applications/output/$application-$version-${user}user-cache --reduce=applications/output/hits-distribution.csv --prefix=$application,$version,$group,$user,
					java $JAVA_OPTS -jar adapters/Cache/target/Cache-1.0.jar --events=applications/output/$application-$version-${user}user-cache --reduce=applications/output/cache-size-distribution.csv --size --prefix=$application,$version,$group,$user,
					java $JAVA_OPTS -jar adapters/Cache/target/Cache-1.0.jar --events=applications/output/$application-$version-${user}user-cache --reduce=applications/output/cache-stptic.csv --ttls=applications/output/ttls-recommended.csv --executions=applications/output/average-executions.csv --prefix=$application,$version,$group,$user,
					if [[ $version == aplcache* ]]; then
						echo "$(date '+%F %T') Reducing parameters of $application with $user users"
						java $JAVA_OPTS -jar adapters/Cache/target/Cache-1.0.jar --uncached=applications/output/$application-$version-${user}user-cache.log --reduce=applications/output/uncached-parameters.csv --prefix=$application,$version,$group,$user, --hash
					fi
				fi
			done
		done
	done
done
