#!/bin/bash

if [ "$(whoami)" != 'root' ]; then
    echo "You have no permission to run $0 as non-root user."
    exit 1;
fi

export JAVA_OPTS="-Xms4096m -Xmx6124m"

host="localhost"
versions=$(echo applications/cached/*/)
applications="*"
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		versions=$2
		if [[ ! -z $3 ]]; then
			applications=$3
		fi
	fi
fi

echo "Executing workloads in host $host for the applications $applications among the versions $versions"
for execution in {1..10}; do
	for user in 1 10 50; do
		for version in $versions; do
			version=${version%/}
			if [[ $applications = "*" ]]; then
				existing_applications=$(echo applications/cached/$version/*/)
			else
				existing_applications=$applications
			fi
			echo "Running $execution execution with $user users of applications $existing_applications"
			for application in $existing_applications; do
				application=${application%/}
				if [[ ! -f applications/workloads/$application-workload-${user}user.json ]]; then
					echo "Generating workload for $application with $user users"
					if [[ $host = "localhost" ]]; then
						export TRACER_ENABLE=false
						docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build
					else
						while ! </dev/tcp/$host/5000; do sleep 5; done
						echo "caching-approaches-comparison export TRACER_ENABLE=false" >/dev/tcp/$host/5000
						echo "caching-approaches-comparison docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build" >/dev/tcp/$host/5000
					fi
					while ! curl -s $host:8080 > /dev/null; do sleep 5; done
					java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --time=1500000 --users=$user --log=applications/workloads/$application-workload-${user}user.json --throughput=applications/output/$application-workload-${user}user-requests --host=$host > applications/output/$application-workload-${user}user-simulator.log 2>&1
					if [[ $host = "localhost" ]]; then
						docker-compose -f applications/uncached/$application/docker-compose.yml down -v
					else
						while ! </dev/tcp/$host/5000; do sleep 5; done
						echo "caching-approaches-comparison docker-compose -f applications/uncached/$application/docker-compose.yml down -v" >/dev/tcp/$host/5000
						sleep 11
					fi
				fi
				echo "Running $application with $user users and execution $execution"
				if [[ $host = "localhost" ]]; then
					export CACHE_EVENTS=/caching-approaches-comparison/applications/output/$application-$version-${user}user-${execution}execution-cache
					docker-compose -f applications/cached/$version/$application/docker-compose.yml up -d --build
				else
					while ! </dev/tcp/$host/5000; do sleep 5; done
					echo "caching-approaches-comparison export CACHE_EVENTS=/caching-approaches-comparison/applications/output/$application-$version-${user}user-${execution}execution-cache" >/dev/tcp/$host/5000
					echo "caching-approaches-comparison docker-compose -f applications/cached/$version/$application/docker-compose.yml up -d --build" >/dev/tcp/$host/5000
				fi
				while ! curl -s $host:8080 > /dev/null; do sleep 5; done
				java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --execute=applications/workloads/$application-workload-${user}user.json --throughput=applications/output/$application-$version-${user}user-${execution}execution-requests --host=$host > applications/output/$application-$version-${user}user-${execution}execution-simulator.log 2>&1
				if [[ $host = "localhost" ]]; then
					docker-compose -f applications/cached/$version/$application/docker-compose.yml down -v
				else
					while ! </dev/tcp/$host/5000; do sleep 5; done
					echo "caching-approaches-comparison docker-compose -f applications/cached/$version/$application/docker-compose.yml down -v" >/dev/tcp/$host/5000
					sleep 11
				fi
			done
		done
	done
done
