#!/bin/bash

if [ "$(whoami)" != 'root' ]; then
    echo "You have no permission to run $0 as non-root user."
    exit 1;
fi

export JAVA_OPTS="-Xms4096m -Xmx6124m"

host="localhost"
applications=$(echo applications/uncached/*/)
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		applications=$2
	fi
fi

echo "Running in host $host for the applications: $applications"
for application in $applications; do
	application=${application%/}
	echo "Running application $application"
	if [[ $host = "localhost" ]]; then
		export TRACER_ENABLE=true
		docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build
	else
		while ! </dev/tcp/$host/5000; do sleep 5; done
		echo "caching-approaches-comparison export TRACER_ENABLE=true" >/dev/tcp/$host/5000
		echo "caching-approaches-comparison docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build" >/dev/tcp/$host/5000
	fi
	while ! curl -s $host:8080 > /dev/null; do sleep 5; done
	java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --time=600000 --users=1 --log=applications/workloads/$application-execution-uncached.json --throughput=applications/output/$application-uncached-requests --host=$host > applications/output/$application-uncached-simulator.log 2>&1
	if [[ $host = "localhost" ]]; then
		docker-compose -f applications/uncached/$application/docker-compose.yml down -v
	else
		while ! </dev/tcp/$host/5000; do sleep 5; done
		echo "caching-approaches-comparison docker-compose -f applications/uncached/$application/docker-compose.yml down -v" >/dev/tcp/$host/5000
		sleep 11
	fi
done
