#!/bin/bash

source functions.sh

if [ "$(whoami)" != 'root' ]; then
	echo "You have no permission to run $0 as non-root user."
	exit 1;
fi

export JAVA_OPTS=${JAVA_OPTS:-"-Xmx7500m"}
JAVA_SERVER_OPTS=${JAVA_SERVER_OPTS:-"-Xmx30000m"}

host="localhost"
groups="aplcache memoizeit"
applications=$(echo applications/uncached/*/)
if [[ ! -z $1 ]]; then
	host=$1
	if [[ ! -z $2 ]]; then
		groups=$2
		if [[ ! -z $3 ]]; then
			applications=$3
		fi
	fi
fi
if [[ $applications = "*" ]]; then
	applications=$(echo applications/uncached/*/)
fi

echo "$(date '+%F %T') Executing workloads in host $host for the applications $applications among the versions $versions"
for application in $applications; do
	application=${application//applications\/uncached\//}
	application=${application%/}
	for user in 25 5 1; do
		if [[ ! -f applications/workloads/$application-workload-${user}user.json ]]; then
			echo "$(date '+%F %T')    Generating workload for $application with $user users"
			command="JAVA_OPTS=$JAVA_SERVER_OPTS TRACER_ENABLE=false docker-compose -f applications/uncached/$application/docker-compose.yml up -d --build"
			execute "$host" "$command"
			while ! curl -s $host:8080 > /dev/null; do sleep 5; done
			sleep 30
			java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --time=600000 --users=$user --log=applications/workloads/$application-workload-${user}user.json --throughput=applications/output/$application-workload-${user}user-requests --host=$host --home="applications/workloads/" > applications/output/$application-workload-${user}user-simulator.log 2>&1
			command="docker-compose -f applications/uncached/$application/docker-compose.yml down -v"
			execute "$host" "$command"
			sleep 30
		fi
		for group in $groups; do
			versions=$(echo applications/$group/*/)
			for version in $versions; do
				version=${version//applications\/$group\//}
				version=${version%/}
				echo "$(date '+%F %T')  Sampling $application with $user users in $version version"
				for execution in {1..10}; do
					if [[ -f applications/output/$application-$version-${user}user-${execution}execution-requests ]]; then
						echo "$(date '+%F %T')   Skipping $application with $user users and execution $execution"
					else
						echo "$(date '+%F %T')   Running $application with $user users and execution $execution"
						command="JAVA_OPTS=$JAVA_SERVER_OPTS TRACER_ENABLE=false CACHE_REFRESH_TTL=false CACHE_EVENTS=null APLCACHE_LOG=null docker-compose -f applications/$group/$version/$application/docker-compose.yml up -d --build"
						execute "$host" "$command"
						while ! curl -s $host:8080 > /dev/null; do sleep 5; done
						sleep 30
						timeout 750 java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --execute=applications/workloads/$application-workload-${user}user.json --throughput=applications/output/$application-$version-${user}user-${execution}execution-requests --host=$host --home="applications/workloads/" > applications/output/$application-$version-${user}user-${execution}execution-simulator.log 2>&1
						command="docker-compose -f applications/$group/$version/$application/docker-compose.yml down -v"
						execute "$host" "$command"
						sleep 30
					fi
				done
				if [[ $version = "uncached" ]]; then
					echo "$(date '+%F %T')  Skipping uncached version of $application with $user users"
				elif [[ -f applications/output/$application-cachemetrics-$version-${user}user-requests ]]; then
					echo "$(date '+%F %T')  Skipping measure of caching performance for $application with $user users"
				else
					echo "$(date '+%F %T')  Running measure of caching performance for $application with $user users"
					command="JAVA_OPTS=$JAVA_SERVER_OPTS TRACER_ENABLE=false CACHE_REFRESH_TTL=false CACHE_EVENTS=/caching-approaches-comparison/applications/output/$application-$version-${user}user-cache APLCACHE_LOG=/caching-approaches-comparison/applications/output/$application-$version-${user}user-cache.log docker-compose -f applications/$group/$version/$application/docker-compose.yml up -d --build"
					execute "$host" "$command"
					while ! curl -s $host:8080 > /dev/null; do sleep 5; done
					sleep 30
					timeout 750 java $JAVA_OPTS -jar adapters/RequestsSimulator/target/RequestsSimulator-1.0.jar --profile=applications/workloads/$application.json --execute=applications/workloads/$application-workload-${user}user.json --throughput=applications/output/$application-cachemetrics-$version-${user}user-requests --host=$host --home="applications/workloads/" > applications/output/$application-cachemetrics-$version-${user}user-simulator.log 2>&1
					command="docker-compose -f applications/$group/$version/$application/docker-compose.yml down -v"
					execute "$host" "$command"
					sleep 30
				fi
			done
		done
	done
done
