library(ggplot2)
library(scales)

sizes <- read.csv("../applications/output/cache-size-distribution.csv")

print("=== cache-size ===")
pdf("cache-size.pdf")

# A function factory for getting integer y-axis values.
integer_breaks <- function(n = 5, ...) {
	fxn <- function(x) {
		breaks <- floor(pretty(x, n, ...))
		names(breaks) <- attr(breaks, "labels")
		breaks
	}
	return(fxn)
}

iter_applications = unique(sizes$application)
for (iter_application in iter_applications) {
	slice_application <- subset(sizes, application == iter_application)
	plot <- ggplot(slice_application, aes(x = time, y = size, group = name)) +
	geom_line(aes(colour = name)) +
	scale_colour_grey(start = 0.1, end = 0.6) +
	scale_y_continuous(breaks = integer_breaks(), limits = c(0, NA)) +
	scale_x_continuous(breaks = integer_breaks(), limits = c(0, NA)) +
	facet_grid(version ~ users, scales = "free") +
	theme(legend.position = "bottom", legend.text = element_text(size = 5)) +
	ggtitle(iter_application)
	print(plot)
}

slice <- aggregate(formula = size~application+group+version+users+time, data = sizes, FUN = sum)

print("=== cache-size-aggregated ===")
pdf("cache-size-aggregated.pdf")

iter_groups = unique(sizes$group)
for (iter_group in iter_groups) {
	comparison_slice = slice[slice$group == iter_group, ]
	plot <- ggplot(comparison_slice, aes(x = time, y = size)) +
		geom_line(aes(colour = factor(users))) +
		scale_colour_grey(start = 0.1, end = 0.6) +
		scale_y_continuous(breaks = integer_breaks(), limits = c(0, NA)) +
		scale_x_continuous(breaks = integer_breaks(), limits = c(0, NA)) +
		facet_grid(application ~ version, scales = "free") +
		theme(legend.position = "bottom") +
		ggtitle(iter_group)
	print(plot)
}
