library(ggplot2)
library(ggrepel)

data <- read.csv2("../time-frame-analysis.csv", header=TRUE, sep=",", dec=".")

print("time-frame-analysis")

data["time"] <- data$time / 1000


pdf("time-frame-analysis.pdf", width = 30, height = 80)

aggregate <- aggregate(formula = input~application+method, data = data, FUN = length)
aggregate = aggregate[aggregate$input > 10 & aggregate$input < 1000, ]
slice = data[data$method %in% aggregate$method, ]

plot <- ggplot(slice, aes(x = time, y = input, color = input)) + 
	geom_point(size = 0.75) +
	facet_wrap(application ~ method, scales = "free", ncol = 6) +
	theme(legend.position = "none") +
	theme(axis.title.y = element_blank(), axis.text.y = element_blank(), axis.ticks.y = element_blank()) +
	theme(axis.title.x = element_blank(), axis.text.x = element_blank(), axis.ticks.x = element_blank())
print(plot)
