/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.execapp;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionReference;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockExecutorLoader
implements ExecutorLoader {
    HashMap<Integer, ExecutableFlow> flows = new HashMap();
    HashMap<String, ExecutableNode> nodes = new HashMap();
    HashMap<Integer, ExecutionReference> refs = new HashMap();
    int flowUpdateCount = 0;
    HashMap<String, Integer> jobUpdateCount = new HashMap();
    Map<Integer, Pair<ExecutionReference, ExecutableFlow>> activeFlows = new HashMap();

    public void uploadExecutableFlow(ExecutableFlow flow) throws ExecutorManagerException {
        this.flows.put(flow.getExecutionId(), flow);
        ++this.flowUpdateCount;
    }

    public ExecutableFlow fetchExecutableFlow(int execId) throws ExecutorManagerException {
        ExecutableFlow flow = (ExecutableFlow)this.flows.get(execId);
        return ExecutableFlow.createExecutableFlowFromObject((Object)flow.toObject());
    }

    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchActiveFlows() throws ExecutorManagerException {
        return this.activeFlows;
    }

    public List<ExecutableFlow> fetchFlowHistory(int projectId, String flowId, int skip, int num) throws ExecutorManagerException {
        return null;
    }

    public void addActiveExecutableReference(ExecutionReference ref) throws ExecutorManagerException {
        this.refs.put(ref.getExecId(), ref);
    }

    public void removeActiveExecutableReference(int execId) throws ExecutorManagerException {
        this.refs.remove(execId);
    }

    public boolean hasActiveExecutableReference(int execId) {
        return this.refs.containsKey(execId);
    }

    public void uploadLogFile(int execId, String name, int attempt, File ... files) throws ExecutorManagerException {
    }

    public void updateExecutableFlow(ExecutableFlow flow) throws ExecutorManagerException {
        ExecutableFlow toUpdate = (ExecutableFlow)this.flows.get(flow.getExecutionId());
        toUpdate.applyUpdateObject(flow.toUpdateObject(0L));
        ++this.flowUpdateCount;
    }

    public void uploadExecutableNode(ExecutableNode node, Props inputParams) throws ExecutorManagerException {
        ExecutableNode exNode = new ExecutableNode();
        exNode.fillExecutableFromMapObject(node.toObject());
        this.nodes.put(node.getId(), exNode);
        this.jobUpdateCount.put(node.getId(), 1);
    }

    public void updateExecutableNode(ExecutableNode node) throws ExecutorManagerException {
        ExecutableNode foundNode = (ExecutableNode)this.nodes.get(node.getId());
        foundNode.setEndTime(node.getEndTime());
        foundNode.setStartTime(node.getStartTime());
        foundNode.setStatus(node.getStatus());
        foundNode.setUpdateTime(node.getUpdateTime());
        Integer value = (Integer)this.jobUpdateCount.get(node.getId());
        if (value == null) {
            throw new ExecutorManagerException("The node has not been uploaded");
        }
        value = value + 1;
        this.jobUpdateCount.put(node.getId(), value);
        ++this.flowUpdateCount;
    }

    public int fetchNumExecutableFlows(int projectId, String flowId) throws ExecutorManagerException {
        return 0;
    }

    public int fetchNumExecutableFlows() throws ExecutorManagerException {
        return 0;
    }

    public int getFlowUpdateCount() {
        return this.flowUpdateCount;
    }

    public Integer getNodeUpdateCount(String jobId) {
        return (Integer)this.jobUpdateCount.get(jobId);
    }

    public ExecutableJobInfo fetchJobInfo(int execId, String jobId, int attempt) throws ExecutorManagerException {
        return null;
    }

    public boolean updateExecutableReference(int execId, long updateTime) throws ExecutorManagerException {
        return true;
    }

    public FileIOUtils.LogData fetchLogs(int execId, String name, int attempt, int startByte, int endByte) throws ExecutorManagerException {
        return null;
    }

    public List<ExecutableFlow> fetchFlowHistory(int skip, int num) throws ExecutorManagerException {
        return null;
    }

    public List<ExecutableFlow> fetchFlowHistory(String projectContains, String flowContains, String userNameContains, int status, long startData, long endData, int skip, int num) throws ExecutorManagerException {
        return null;
    }

    public List<ExecutableJobInfo> fetchJobHistory(int projectId, String jobId, int skip, int size) throws ExecutorManagerException {
        return null;
    }

    public int fetchNumExecutableNodes(int projectId, String jobId) throws ExecutorManagerException {
        return 0;
    }

    public Props fetchExecutionJobInputProps(int execId, String jobId) throws ExecutorManagerException {
        return null;
    }

    public Props fetchExecutionJobOutputProps(int execId, String jobId) throws ExecutorManagerException {
        return null;
    }

    public Pair<Props, Props> fetchExecutionJobProps(int execId, String jobId) throws ExecutorManagerException {
        return null;
    }

    public List<ExecutableJobInfo> fetchJobInfoAttempts(int execId, String jobId) throws ExecutorManagerException {
        return null;
    }

    public int removeExecutionLogsByTime(long millis) throws ExecutorManagerException {
        return 0;
    }

    public List<ExecutableFlow> fetchFlowHistory(int projectId, String flowId, int skip, int num, Status status) throws ExecutorManagerException {
        return null;
    }

    public List<Object> fetchAttachments(int execId, String name, int attempt) throws ExecutorManagerException {
        return null;
    }

    public void uploadAttachmentFile(ExecutableNode node, File file) throws ExecutorManagerException {
    }
}

