/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.trigger;

import azkaban.executor.ExecutionOptions;
import azkaban.trigger.ActionTypeLoader;
import azkaban.trigger.CheckerTypeLoader;
import azkaban.trigger.Condition;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerException;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TriggerTest {
    private CheckerTypeLoader checkerLoader;
    private ActionTypeLoader actionLoader;

    @Before
    public void setup() throws TriggerException {
        this.checkerLoader = new CheckerTypeLoader();
        this.checkerLoader.init(new Props());
        Condition.setCheckerLoader((CheckerTypeLoader)this.checkerLoader);
        this.actionLoader = new ActionTypeLoader();
        this.actionLoader.init(new Props());
        Trigger.setActionTypeLoader((ActionTypeLoader)this.actionLoader);
    }

    @Test
    public void jsonConversionTest() throws Exception {
        DateTime now = DateTime.now();
        BasicTimeChecker checker1 = new BasicTimeChecker("timeChecker1", now.getMillis(), now.getZone(), true, true, Utils.parsePeriodString((String)"1h"));
        HashMap<String, BasicTimeChecker> checkers1 = new HashMap<String, BasicTimeChecker>();
        checkers1.put(checker1.getId(), checker1);
        String expr1 = String.valueOf(checker1.getId()) + ".eval()";
        Condition triggerCond = new Condition(checkers1, expr1);
        Condition expireCond = new Condition(checkers1, expr1);
        ArrayList<ExecuteFlowAction> actions = new ArrayList<ExecuteFlowAction>();
        ExecuteFlowAction action = new ExecuteFlowAction("executeAction", 1, "testProj", "testFlow", "azkaban", new ExecutionOptions(), null);
        actions.add(action);
        Trigger t = new Trigger(now.getMillis(), now.getMillis(), "azkaban", "test", triggerCond, expireCond, actions);
        File temp = File.createTempFile("temptest", "temptest");
        temp.deleteOnExit();
        Map obj = t.toJson();
        JSONUtils.toJSON((Object)obj, (File)temp);
        Trigger t2 = Trigger.fromJson((Object)JSONUtils.parseJSONFromFile((File)temp));
        Assert.assertTrue((boolean)t.getSource().equals(t2.getSource()));
        Assert.assertTrue((t.getTriggerId() == t2.getTriggerId() ? 1 : 0) != 0);
    }
}

