/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.executor;

import azkaban.jobExecutor.AbstractProcessJob;
import azkaban.utils.Props;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class InteractiveTestJob
extends AbstractProcessJob {
    private static ConcurrentHashMap<String, InteractiveTestJob> testJobs = new ConcurrentHashMap();
    private Props generatedProperties = new Props();
    private boolean isWaiting = true;
    private boolean succeed = true;

    public static InteractiveTestJob getTestJob(String name) {
        return (InteractiveTestJob)testJobs.get(name);
    }

    public static void clearTestJobs() {
        testJobs.clear();
    }

    public InteractiveTestJob(String jobId, Props sysProps, Props jobProps, Logger log) {
        super(jobId, sysProps, jobProps, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        String id;
        String nestedFlowPath = this.getJobProps().get((Object)"azkaban.flow.nested.path");
        String groupName = this.getJobProps().getString("group", null);
        String string = id = nestedFlowPath == null ? this.getId() : nestedFlowPath;
        if (groupName != null) {
            id = String.valueOf(groupName) + ":" + id;
        }
        testJobs.put(id, this);
        while (this.isWaiting) {
            InteractiveTestJob interactiveTestJob = this;
            synchronized (interactiveTestJob) {
                try {
                    this.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isWaiting) {
                    if (!this.succeed) {
                        throw new RuntimeException("Forced failure of " + this.getId());
                    }
                    this.info("Job " + this.getId() + " succeeded.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failJob() {
        InteractiveTestJob interactiveTestJob = this;
        synchronized (interactiveTestJob) {
            this.succeed = false;
            this.isWaiting = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void succeedJob() {
        InteractiveTestJob interactiveTestJob = this;
        synchronized (interactiveTestJob) {
            this.succeed = true;
            this.isWaiting = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void succeedJob(Props generatedProperties) {
        InteractiveTestJob interactiveTestJob = this;
        synchronized (interactiveTestJob) {
            this.generatedProperties = generatedProperties;
            this.succeed = true;
            this.isWaiting = false;
            this.notify();
        }
    }

    public Props getJobGeneratedProperties() {
        return this.generatedProperties;
    }

    public void cancel() throws InterruptedException {
        this.info("Killing job");
        this.failJob();
    }
}

