/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.executor.Status;
import java.text.NumberFormat;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

public class WebUtils {
    public static final String DATE_TIME_STRING = "YYYY-MM-dd HH:mm:ss";
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;
    private static final long ONE_TB = 0x10000000000L;
    private static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$Status;

    public String formatDate(long timeMS) {
        if (timeMS == -1L) {
            return "-";
        }
        return DateTimeFormat.forPattern((String)DATE_TIME_STRING).print(timeMS);
    }

    public String formatDuration(long startTime, long endTime) {
        if (startTime == -1L) {
            return "-";
        }
        long durationMS = endTime == -1L ? System.currentTimeMillis() - startTime : endTime - startTime;
        long seconds = durationMS / 1000L;
        if (seconds < 60L) {
            return String.valueOf(seconds) + " sec";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes < 60L) {
            return String.valueOf(minutes) + "m " + seconds + "s";
        }
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours < 24L) {
            return String.valueOf(hours) + "h " + minutes + "m " + seconds + "s";
        }
        long days = hours / 24L;
        return String.valueOf(days) + "d " + (hours %= 24L) + "h " + minutes + "m";
    }

    /*
     * Exception decompiling
     */
    public String formatStatus(Status status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String formatDateTime(DateTime dt) {
        return DateTimeFormat.forPattern((String)DATE_TIME_STRING).print((ReadableInstant)dt);
    }

    public String formatDateTime(long timestamp) {
        return this.formatDateTime(new DateTime(timestamp));
    }

    public String formatPeriod(ReadablePeriod period) {
        String periodStr = "null";
        if (period == null) {
            return periodStr;
        }
        if (period.get(DurationFieldType.years()) > 0) {
            int years = period.get(DurationFieldType.years());
            periodStr = String.valueOf(years) + " year(s)";
        } else if (period.get(DurationFieldType.months()) > 0) {
            int months = period.get(DurationFieldType.months());
            periodStr = String.valueOf(months) + " month(s)";
        } else if (period.get(DurationFieldType.weeks()) > 0) {
            int weeks = period.get(DurationFieldType.weeks());
            periodStr = String.valueOf(weeks) + " week(s)";
        } else if (period.get(DurationFieldType.days()) > 0) {
            int days = period.get(DurationFieldType.days());
            periodStr = String.valueOf(days) + " day(s)";
        } else if (period.get(DurationFieldType.hours()) > 0) {
            int hours = period.get(DurationFieldType.hours());
            periodStr = String.valueOf(hours) + " hour(s)";
        } else if (period.get(DurationFieldType.minutes()) > 0) {
            int minutes = period.get(DurationFieldType.minutes());
            periodStr = String.valueOf(minutes) + " minute(s)";
        } else if (period.get(DurationFieldType.seconds()) > 0) {
            int seconds = period.get(DurationFieldType.seconds());
            periodStr = String.valueOf(seconds) + " second(s)";
        }
        return periodStr;
    }

    public String extractNumericalId(String execId) {
        int index = execId.indexOf(46);
        int index2 = execId.indexOf(46, index + 1);
        return execId.substring(0, index2);
    }

    public String displayBytes(long sizeBytes) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        if (sizeBytes >= 0x10000000000L) {
            return String.valueOf(nf.format((double)sizeBytes / 1.099511627776E12)) + " tb";
        }
        if (sizeBytes >= 0x40000000L) {
            return String.valueOf(nf.format((double)sizeBytes / 1.073741824E9)) + " gb";
        }
        if (sizeBytes >= 0x100000L) {
            return String.valueOf(nf.format((double)sizeBytes / 1048576.0)) + " mb";
        }
        if (sizeBytes >= 1024L) {
            return String.valueOf(nf.format((double)sizeBytes / 1024.0)) + " kb";
        }
        return String.valueOf(sizeBytes) + " B";
    }

    static /* synthetic */ int[] $SWITCH_TABLE$azkaban$executor$Status() {
        if ($SWITCH_TABLE$azkaban$executor$Status != null) {
            return $SWITCH_TABLE$azkaban$executor$Status;
        }
        int[] nArray = new int[Status.values().length];
        try {
            nArray[Status.CANCELLED.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.DISABLED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED_FINISHING.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.FAILED_SUCCEEDED.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.KILLED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.PAUSED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.PREPARING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.QUEUED.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.READY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.RUNNING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.SKIPPED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Status.SUCCEEDED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$azkaban$executor$Status = nArray;
        return nArray;
    }
}

