/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.execapp;

import azkaban.execapp.FlowRunner;
import azkaban.execapp.event.EventListener;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.jobtype.JobTypeManager;
import azkaban.project.Project;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectManagerException;
import azkaban.test.execapp.EventCollectorListener;
import azkaban.test.execapp.MockExecutorLoader;
import azkaban.test.execapp.MockProjectLoader;
import azkaban.test.executor.InteractiveTestJob;
import azkaban.test.executor.JavaJob;
import azkaban.utils.DirectoryFlowLoader;
import azkaban.utils.Props;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FlowRunnerTest2 {
    private File workingDir;
    private JobTypeManager jobtypeManager;
    private ProjectLoader fakeProjectLoader;
    private ExecutorLoader fakeExecutorLoader;
    private Logger logger = Logger.getLogger(FlowRunnerTest2.class);
    private Project project;
    private Map<String, Flow> flowMap;
    private static int id = 101;

    @Before
    public void setUp() throws Exception {
        System.out.println("Create temp dir");
        this.workingDir = new File("_AzkabanTestDir_" + System.currentTimeMillis());
        if (this.workingDir.exists()) {
            FileUtils.deleteDirectory((File)this.workingDir);
        }
        this.workingDir.mkdirs();
        this.jobtypeManager = new JobTypeManager(null, this.getClass().getClassLoader());
        this.jobtypeManager.registerJobType("java", JavaJob.class);
        this.jobtypeManager.registerJobType("test", InteractiveTestJob.class);
        this.fakeProjectLoader = new MockProjectLoader(this.workingDir);
        this.fakeExecutorLoader = new MockExecutorLoader();
        this.project = new Project(1, "testProject");
        File dir = new File("unit/executions/embedded2");
        this.prepareProject(dir);
        InteractiveTestJob.clearTestJobs();
    }

    @After
    public void tearDown() throws IOException {
        System.out.println("Teardown temp dir");
        if (this.workingDir != null) {
            FileUtils.deleteDirectory((File)this.workingDir);
            this.workingDir = null;
        }
    }

    @Test
    public void testBasicRun() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        ExecutableFlow flow = runner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        Props joba = ((ExecutableNode)nodeMap.get("joba")).getInputProps();
        Assert.assertEquals((Object)"joba.1", (Object)joba.get((Object)"param1"));
        Assert.assertEquals((Object)"test1.2", (Object)joba.get((Object)"param2"));
        Assert.assertEquals((Object)"test1.3", (Object)joba.get((Object)"param3"));
        Assert.assertEquals((Object)"override.4", (Object)joba.get((Object)"param4"));
        Assert.assertEquals((Object)"test2.5", (Object)joba.get((Object)"param5"));
        Assert.assertEquals((Object)"test2.6", (Object)joba.get((Object)"param6"));
        Assert.assertEquals((Object)"test2.7", (Object)joba.get((Object)"param7"));
        Assert.assertEquals((Object)"test2.8", (Object)joba.get((Object)"param8"));
        Props joba1 = ((ExecutableNode)nodeMap.get("joba1")).getInputProps();
        Assert.assertEquals((Object)"test1.1", (Object)joba1.get((Object)"param1"));
        Assert.assertEquals((Object)"test1.2", (Object)joba1.get((Object)"param2"));
        Assert.assertEquals((Object)"test1.3", (Object)joba1.get((Object)"param3"));
        Assert.assertEquals((Object)"override.4", (Object)joba1.get((Object)"param4"));
        Assert.assertEquals((Object)"test2.5", (Object)joba1.get((Object)"param5"));
        Assert.assertEquals((Object)"test2.6", (Object)joba1.get((Object)"param6"));
        Assert.assertEquals((Object)"test2.7", (Object)joba1.get((Object)"param7"));
        Assert.assertEquals((Object)"test2.8", (Object)joba1.get((Object)"param8"));
        InteractiveTestJob.getTestJob((String)"joba").succeedJob(Props.of((String[])new String[]{"output.joba", "joba", "output.override", "joba"}));
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        ExecutableNode node = (ExecutableNode)nodeMap.get("jobb");
        Assert.assertEquals((Object)Status.RUNNING, (Object)node.getStatus());
        Props jobb = node.getInputProps();
        Assert.assertEquals((Object)"test1.1", (Object)jobb.get((Object)"param1"));
        Assert.assertEquals((Object)"test1.1", (Object)jobb.get((Object)"param1"));
        Assert.assertEquals((Object)"test1.2", (Object)jobb.get((Object)"param2"));
        Assert.assertEquals((Object)"test1.3", (Object)jobb.get((Object)"param3"));
        Assert.assertEquals((Object)"override.4", (Object)jobb.get((Object)"param4"));
        Assert.assertEquals((Object)"test2.5", (Object)jobb.get((Object)"param5"));
        Assert.assertEquals((Object)"test2.6", (Object)jobb.get((Object)"param6"));
        Assert.assertEquals((Object)"test2.7", (Object)jobb.get((Object)"param7"));
        Assert.assertEquals((Object)"test2.8", (Object)jobb.get((Object)"param8"));
        Assert.assertEquals((Object)"test2.8", (Object)jobb.get((Object)"param8"));
        Assert.assertEquals((Object)"moo", (Object)jobb.get((Object)"testprops"));
        Assert.assertEquals((Object)"jobb", (Object)jobb.get((Object)"output.override"));
        Assert.assertEquals((Object)"joba", (Object)jobb.get((Object)"output.joba"));
        Props jobbInnerJobA = ((ExecutableNode)nodeMap.get("jobb:innerJobA")).getInputProps();
        Assert.assertEquals((Object)"test1.1", (Object)jobbInnerJobA.get((Object)"param1"));
        Assert.assertEquals((Object)"test1.2", (Object)jobbInnerJobA.get((Object)"param2"));
        Assert.assertEquals((Object)"test1.3", (Object)jobbInnerJobA.get((Object)"param3"));
        Assert.assertEquals((Object)"override.4", (Object)jobbInnerJobA.get((Object)"param4"));
        Assert.assertEquals((Object)"test2.5", (Object)jobbInnerJobA.get((Object)"param5"));
        Assert.assertEquals((Object)"test2.6", (Object)jobbInnerJobA.get((Object)"param6"));
        Assert.assertEquals((Object)"test2.7", (Object)jobbInnerJobA.get((Object)"param7"));
        Assert.assertEquals((Object)"test2.8", (Object)jobbInnerJobA.get((Object)"param8"));
        Assert.assertEquals((Object)"joba", (Object)jobbInnerJobA.get((Object)"output.joba"));
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob(Props.of((String[])new String[]{"output.jobb.innerJobA", "jobb.innerJobA"}));
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        Props jobbInnerJobB = ((ExecutableNode)nodeMap.get("jobb:innerJobB")).getInputProps();
        Assert.assertEquals((Object)"test1.1", (Object)jobbInnerJobB.get((Object)"param1"));
        Assert.assertEquals((Object)"override.4", (Object)jobbInnerJobB.get((Object)"param4"));
        Assert.assertEquals((Object)"jobb.innerJobA", (Object)jobbInnerJobB.get((Object)"output.jobb.innerJobA"));
        Assert.assertEquals((Object)"moo", (Object)jobbInnerJobB.get((Object)"testprops"));
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").succeedJob(Props.of((String[])new String[]{"output.jobb.innerJobB", "jobb.innerJobB"}));
        InteractiveTestJob.getTestJob((String)"jobb:innerJobC").succeedJob(Props.of((String[])new String[]{"output.jobb.innerJobC", "jobb.innerJobC"}));
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobB", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerFlow", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        Props jobbInnerJobD = ((ExecutableNode)nodeMap.get("jobb:innerFlow")).getInputProps();
        Assert.assertEquals((Object)"test1.1", (Object)jobbInnerJobD.get((Object)"param1"));
        Assert.assertEquals((Object)"override.4", (Object)jobbInnerJobD.get((Object)"param4"));
        Assert.assertEquals((Object)"jobb.innerJobB", (Object)jobbInnerJobD.get((Object)"output.jobb.innerJobB"));
        Assert.assertEquals((Object)"jobb.innerJobC", (Object)jobbInnerJobD.get((Object)"output.jobb.innerJobC"));
        InteractiveTestJob.getTestJob((String)"jobb:innerFlow").succeedJob(Props.of((String[])new String[]{"output1.jobb", "test1", "output2.jobb", "test2"}));
        this.pause(250L);
        expectedStateMap.put("jobb:innerFlow", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        Props jobbOutput = ((ExecutableNode)nodeMap.get("jobb")).getOutputProps();
        Assert.assertEquals((Object)"test1", (Object)jobbOutput.get((Object)"output1.jobb"));
        Assert.assertEquals((Object)"test2", (Object)jobbOutput.get((Object)"output2.jobb"));
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob(Props.of((String[])new String[]{"output.jobc", "jobc"}));
        this.pause(250L);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").succeedJob();
        this.pause(250L);
        InteractiveTestJob.getTestJob((String)"jobd:innerFlow2").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobd:innerFlow2", Status.SUCCEEDED);
        expectedStateMap.put("jobd", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        Props jobd = ((ExecutableNode)nodeMap.get("jobe")).getInputProps();
        Assert.assertEquals((Object)"test1", (Object)jobd.get((Object)"output1.jobb"));
        Assert.assertEquals((Object)"jobc", (Object)jobd.get((Object)"output.jobc"));
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        this.pause(250L);
        InteractiveTestJob.getTestJob((String)"jobe").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.SUCCEEDED);
        expectedStateMap.put("jobf", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobf").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobf", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testDisabledNormal() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        flow.getExecutableNode("jobb").setStatus(Status.DISABLED);
        ((ExecutableFlowBase)flow.getExecutableNode("jobd")).getExecutableNode("innerJobA").setStatus(Status.DISABLED);
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.SKIPPED);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.SKIPPED);
        expectedStateMap.put("jobd:innerFlow2", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.READY);
        expectedStateMap.put("jobb:innerJobB", Status.READY);
        expectedStateMap.put("jobb:innerJobC", Status.READY);
        expectedStateMap.put("jobb:innerFlow", Status.READY);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerFlow2").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerFlow2", Status.SUCCEEDED);
        expectedStateMap.put("jobd", Status.SUCCEEDED);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobe").succeedJob();
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobe", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobf", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobf").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobf", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testNormalFailure1() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").failJob();
        this.pause(250L);
        Assert.assertEquals((Object)Status.FAILED_FINISHING, (Object)flow.getStatus());
        expectedStateMap.put("joba", Status.FAILED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.CANCELLED);
        expectedStateMap.put("jobc", Status.CANCELLED);
        expectedStateMap.put("jobd", Status.CANCELLED);
        expectedStateMap.put("jobd:innerJobA", Status.READY);
        expectedStateMap.put("jobd:innerFlow2", Status.READY);
        expectedStateMap.put("jobb:innerJobA", Status.READY);
        expectedStateMap.put("jobb:innerFlow", Status.READY);
        expectedStateMap.put("jobe", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobf", Status.CANCELLED);
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testNormalFailure2() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        InteractiveTestJob.getTestJob((String)"joba1").failJob();
        this.pause(250L);
        expectedStateMap.put("joba1", Status.FAILED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.CANCELLED);
        expectedStateMap.put("jobb:innerJobC", Status.CANCELLED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobb", Status.KILLED);
        expectedStateMap.put("jobd", Status.KILLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.FAILED_FINISHING, (Object)flow.getStatus());
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testNormalFailure3() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").failJob();
        this.pause(250L);
        expectedStateMap.put("jobb", Status.FAILED_FINISHING);
        expectedStateMap.put("jobb:innerJobB", Status.FAILED);
        Assert.assertEquals((Object)Status.FAILED_FINISHING, (Object)flow.getStatus());
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobC").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobd", Status.KILLED);
        expectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobb", Status.FAILED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testFailedFinishingFailure3() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf", ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE);
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").failJob();
        this.pause(250L);
        expectedStateMap.put("jobb", Status.FAILED_FINISHING);
        expectedStateMap.put("jobb:innerJobB", Status.FAILED);
        Assert.assertEquals((Object)Status.FAILED_FINISHING, (Object)flow.getStatus());
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobC").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb", Status.FAILED);
        expectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobd:innerFlow2", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobd:innerFlow2").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerFlow2", Status.SUCCEEDED);
        expectedStateMap.put("jobd", Status.SUCCEEDED);
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testCancelOnFailure() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf", ExecutionOptions.FailureAction.CANCEL_ALL);
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").failJob();
        this.pause(250L);
        expectedStateMap.put("jobb", Status.FAILED);
        expectedStateMap.put("jobb:innerJobB", Status.FAILED);
        expectedStateMap.put("jobb:innerJobC", Status.KILLED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobc", Status.KILLED);
        expectedStateMap.put("jobd", Status.KILLED);
        expectedStateMap.put("jobd:innerJobA", Status.KILLED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertFalse((boolean)thread.isAlive());
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
    }

    @Test
    public void testRetryOnFailure() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        flow.getExecutableNode("joba").setStatus(Status.DISABLED);
        ((ExecutableFlowBase)flow.getExecutableNode("jobb")).getExecutableNode("innerFlow").setStatus(Status.DISABLED);
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.SKIPPED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").failJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobC").failJob();
        this.pause(250L);
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb", Status.FAILED);
        expectedStateMap.put("jobb:innerJobB", Status.FAILED);
        expectedStateMap.put("jobb:innerJobC", Status.FAILED);
        expectedStateMap.put("jobb:innerFlow", Status.SKIPPED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobd", Status.KILLED);
        Assert.assertEquals((Object)Status.FAILED_FINISHING, (Object)flow.getStatus());
        this.compareStates(expectedStateMap, nodeMap);
        ExecutableNode node = (ExecutableNode)nodeMap.get("jobd:innerFlow2");
        ExecutableFlowBase base = node.getParentFlow();
        for (String nodeId : node.getInNodes()) {
            ExecutableNode inNode = base.getExecutableNode(nodeId);
            System.out.println(String.valueOf(inNode.getId()) + " > " + inNode.getStatus());
        }
        runner.retryFailures("me");
        this.pause(500L);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerFlow", Status.DISABLED);
        expectedStateMap.put("jobd:innerFlow2", Status.RUNNING);
        Assert.assertEquals((Object)Status.RUNNING, (Object)flow.getStatus());
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertTrue((boolean)thread.isAlive());
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobC").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerFlow2").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerFlow", Status.SKIPPED);
        expectedStateMap.put("jobb", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        expectedStateMap.put("jobd", Status.SUCCEEDED);
        expectedStateMap.put("jobd:innerFlow2", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobe").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobe", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobf", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobf").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobf", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testCancel() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf", ExecutionOptions.FailureAction.CANCEL_ALL);
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(1000L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        runner.kill("me");
        this.pause(250L);
        expectedStateMap.put("jobb", Status.KILLED);
        expectedStateMap.put("jobb:innerJobB", Status.KILLED);
        expectedStateMap.put("jobb:innerJobC", Status.KILLED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobc", Status.KILLED);
        expectedStateMap.put("jobd", Status.KILLED);
        expectedStateMap.put("jobd:innerJobA", Status.KILLED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        Assert.assertEquals((Object)Status.KILLED, (Object)flow.getStatus());
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testManualCancelOnFailure() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        ExecutableFlow flow = runner.getExecutableFlow();
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").failJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobB", Status.FAILED);
        expectedStateMap.put("jobb", Status.FAILED_FINISHING);
        Assert.assertEquals((Object)Status.FAILED_FINISHING, (Object)flow.getStatus());
        this.compareStates(expectedStateMap, nodeMap);
        runner.kill("me");
        this.pause(1000L);
        expectedStateMap.put("jobb", Status.FAILED);
        expectedStateMap.put("jobb:innerJobC", Status.KILLED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobc", Status.KILLED);
        expectedStateMap.put("jobd", Status.KILLED);
        expectedStateMap.put("jobd:innerJobA", Status.KILLED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        Assert.assertEquals((Object)Status.KILLED, (Object)flow.getStatus());
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testPause() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        ExecutableFlow flow = runner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        runner.pause("test");
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)flow.getStatus(), (Object)Status.PAUSED);
        runner.resume("test");
        this.pause(250L);
        Assert.assertEquals((Object)flow.getStatus(), (Object)Status.RUNNING);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        runner.pause("test");
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob(Props.of((String[])new String[]{"output.jobb.innerJobA", "jobb.innerJobA"}));
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        runner.resume("test");
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").succeedJob(Props.of((String[])new String[]{"output.jobb.innerJobB", "jobb.innerJobB"}));
        InteractiveTestJob.getTestJob((String)"jobb:innerJobC").succeedJob(Props.of((String[])new String[]{"output.jobb.innerJobC", "jobb.innerJobC"}));
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobB", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerFlow", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobb:innerFlow").succeedJob(Props.of((String[])new String[]{"output1.jobb", "test1", "output2.jobb", "test2"}));
        this.pause(250L);
        expectedStateMap.put("jobb:innerFlow", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob(Props.of((String[])new String[]{"output.jobc", "jobc"}));
        this.pause(250L);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").succeedJob();
        this.pause(250L);
        InteractiveTestJob.getTestJob((String)"jobd:innerFlow2").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobd:innerFlow2", Status.SUCCEEDED);
        expectedStateMap.put("jobd", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        this.pause(250L);
        InteractiveTestJob.getTestJob((String)"jobe").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.SUCCEEDED);
        expectedStateMap.put("jobf", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"jobf").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobf", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testPauseKill() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf");
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        ExecutableFlow flow = runner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        runner.pause("me");
        this.pause(250L);
        Assert.assertEquals((Object)flow.getStatus(), (Object)Status.PAUSED);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        expectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        runner.kill("me");
        this.pause(250L);
        expectedStateMap.put("joba1", Status.KILLED);
        expectedStateMap.put("jobb:innerJobB", Status.CANCELLED);
        expectedStateMap.put("jobb:innerJobC", Status.CANCELLED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobb", Status.KILLED);
        expectedStateMap.put("jobc", Status.KILLED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobd", Status.KILLED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.KILLED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testPauseFail() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf", ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING);
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        ExecutableFlow flow = runner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        runner.pause("me");
        this.pause(250L);
        Assert.assertEquals((Object)flow.getStatus(), (Object)Status.PAUSED);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").failJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerJobA", Status.FAILED);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)flow.getStatus(), (Object)Status.PAUSED);
        runner.resume("me");
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobB", Status.CANCELLED);
        expectedStateMap.put("jobb:innerJobC", Status.CANCELLED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobb", Status.KILLED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobd", Status.FAILED);
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob();
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testPauseFailFinishAll() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf", ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE);
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        ExecutableFlow flow = runner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(250L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        runner.pause("me");
        this.pause(250L);
        Assert.assertEquals((Object)flow.getStatus(), (Object)Status.PAUSED);
        InteractiveTestJob.getTestJob((String)"jobb:innerJobA").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").failJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerJobA", Status.FAILED);
        expectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        this.compareStates(expectedStateMap, nodeMap);
        runner.resume("me");
        this.pause(250L);
        expectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobd", Status.FAILED);
        InteractiveTestJob.getTestJob((String)"jobc").succeedJob();
        InteractiveTestJob.getTestJob((String)"joba1").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobB").succeedJob();
        InteractiveTestJob.getTestJob((String)"jobb:innerJobC").succeedJob();
        this.pause(250L);
        InteractiveTestJob.getTestJob((String)"jobb:innerFlow").succeedJob();
        this.pause(250L);
        expectedStateMap.put("jobc", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobB", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        expectedStateMap.put("jobb:innerFlow", Status.SUCCEEDED);
        expectedStateMap.put("jobb", Status.SUCCEEDED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testPauseFailKill() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner runner = this.createFlowRunner(eventCollector, "jobf", ExecutionOptions.FailureAction.CANCEL_ALL);
        HashMap<String, Status> expectedStateMap = new HashMap<String, Status>();
        HashMap nodeMap = new HashMap();
        ExecutableFlow flow = runner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)flow, expectedStateMap, nodeMap);
        Thread thread = this.runFlowRunnerInThread(runner);
        this.pause(250L);
        expectedStateMap.put("joba", Status.RUNNING);
        expectedStateMap.put("joba1", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        InteractiveTestJob.getTestJob((String)"joba").succeedJob();
        this.pause(500L);
        expectedStateMap.put("joba", Status.SUCCEEDED);
        expectedStateMap.put("joba1", Status.RUNNING);
        expectedStateMap.put("jobb", Status.RUNNING);
        expectedStateMap.put("jobc", Status.RUNNING);
        expectedStateMap.put("jobd", Status.RUNNING);
        expectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        expectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        this.compareStates(expectedStateMap, nodeMap);
        runner.pause("me");
        this.pause(250L);
        Assert.assertEquals((Object)flow.getStatus(), (Object)Status.PAUSED);
        InteractiveTestJob.getTestJob((String)"jobd:innerJobA").failJob();
        this.pause(250L);
        expectedStateMap.put("jobd:innerJobA", Status.FAILED);
        expectedStateMap.put("jobd:innerFlow2", Status.CANCELLED);
        expectedStateMap.put("jobd", Status.FAILED);
        expectedStateMap.put("jobb:innerJobA", Status.KILLED);
        expectedStateMap.put("jobb:innerJobB", Status.CANCELLED);
        expectedStateMap.put("jobb:innerJobC", Status.CANCELLED);
        expectedStateMap.put("jobb:innerFlow", Status.CANCELLED);
        expectedStateMap.put("jobb", Status.KILLED);
        expectedStateMap.put("jobc", Status.KILLED);
        expectedStateMap.put("jobe", Status.CANCELLED);
        expectedStateMap.put("jobf", Status.CANCELLED);
        expectedStateMap.put("joba1", Status.KILLED);
        this.compareStates(expectedStateMap, nodeMap);
        Assert.assertEquals((Object)Status.FAILED, (Object)flow.getStatus());
        Assert.assertFalse((boolean)thread.isAlive());
    }

    private Thread runFlowRunnerInThread(FlowRunner runner) {
        Thread thread = new Thread((Runnable)runner);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause(long millisec) {
        FlowRunnerTest2 flowRunnerTest2 = this;
        synchronized (flowRunnerTest2) {
            try {
                this.wait(millisec);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void createExpectedStateMap(ExecutableFlowBase flow, Map<String, Status> expectedStateMap, Map<String, ExecutableNode> nodeMap) {
        for (ExecutableNode node : flow.getExecutableNodes()) {
            expectedStateMap.put(node.getNestedId(), node.getStatus());
            nodeMap.put(node.getNestedId(), node);
            if (!(node instanceof ExecutableFlowBase)) continue;
            this.createExpectedStateMap((ExecutableFlowBase)node, expectedStateMap, nodeMap);
        }
    }

    private void compareStates(Map<String, Status> expectedStateMap, Map<String, ExecutableNode> nodeMap) {
        for (String printedId : expectedStateMap.keySet()) {
            ExecutableNode node;
            Status expectedStatus = expectedStateMap.get(printedId);
            if (expectedStatus == (node = nodeMap.get(printedId)).getStatus()) continue;
            Assert.fail((String)("Expected values do not match for " + printedId + ". Expected " + expectedStatus + ", instead received " + node.getStatus()));
        }
    }

    private void prepareProject(File directory) throws ProjectManagerException, IOException {
        DirectoryFlowLoader loader = new DirectoryFlowLoader(this.logger);
        loader.loadProjectFlow(directory);
        if (!loader.getErrors().isEmpty()) {
            for (String error : loader.getErrors()) {
                System.out.println(error);
            }
            throw new RuntimeException("Errors found in setup");
        }
        this.flowMap = loader.getFlowMap();
        this.project.setFlows(this.flowMap);
        FileUtils.copyDirectory((File)directory, (File)this.workingDir);
    }

    private FlowRunner createFlowRunner(EventCollectorListener eventCollector, String flowName) throws Exception {
        return this.createFlowRunner(eventCollector, flowName, ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING);
    }

    private FlowRunner createFlowRunner(EventCollectorListener eventCollector, String flowName, ExecutionOptions.FailureAction action) throws Exception {
        Flow flow = (Flow)this.flowMap.get(flowName);
        int exId = id++;
        ExecutableFlow exFlow = new ExecutableFlow(this.project, flow);
        exFlow.setExecutionPath(this.workingDir.getPath());
        exFlow.setExecutionId(exId);
        HashMap<String, String> flowParam = new HashMap<String, String>();
        flowParam.put("param4", "override.4");
        flowParam.put("param10", "override.10");
        flowParam.put("param11", "override.11");
        exFlow.getExecutionOptions().addAllFlowParameters(flowParam);
        exFlow.getExecutionOptions().setFailureAction(action);
        this.fakeExecutorLoader.uploadExecutableFlow(exFlow);
        FlowRunner runner = new FlowRunner(this.fakeExecutorLoader.fetchExecutableFlow(exId), this.fakeExecutorLoader, this.fakeProjectLoader, this.jobtypeManager);
        runner.addListener((EventListener)eventCollector);
        return runner;
    }
}

