/*
 * Decompiled with CFR 0.152.
 */
package azkaban.restli;

import azkaban.project.Project;
import azkaban.project.ProjectManager;
import azkaban.project.ProjectManagerException;
import azkaban.restli.ResourceUtils;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.user.UserManagerException;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanWebServer;
import com.linkedin.restli.server.annotations.Action;
import com.linkedin.restli.server.annotations.ActionParam;
import com.linkedin.restli.server.annotations.RestLiActions;
import com.linkedin.restli.server.resources.ResourceContextHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@RestLiActions(name="project", namespace="azkaban.restli")
public class ProjectManagerResource
extends ResourceContextHolder {
    private static final Logger logger = Logger.getLogger(ProjectManagerResource.class);

    public AzkabanWebServer getAzkaban() {
        return AzkabanWebServer.getInstance();
    }

    @Action(name="deploy")
    public String deploy(@ActionParam(value="sessionId") String sessionId, @ActionParam(value="projectName") String projectName, @ActionParam(value="packageUrl") String packageUrl) throws ProjectManagerException, UserManagerException, ServletException, IOException {
        logger.info((Object)("Deploy called. {sessionId: " + sessionId + ", projectName: " + projectName + ", packageUrl:" + packageUrl + "}"));
        String ip = (String)this.getContext().getRawRequestContext().getLocalAttr("REMOTE_ADDR");
        User user = ResourceUtils.getUserFromSessionId((String)sessionId, (String)ip);
        ProjectManager projectManager = this.getAzkaban().getProjectManager();
        Project project = projectManager.getProject(projectName);
        if (project == null) {
            throw new ProjectManagerException("Project '" + projectName + "' not found.");
        }
        if (!ResourceUtils.hasPermission((Project)project, (User)user, (Permission.Type)Permission.Type.WRITE)) {
            String errorMsg = "User " + user.getUserId() + " has no permission to write to project " + project.getName();
            logger.error((Object)errorMsg);
            throw new ProjectManagerException(errorMsg);
        }
        logger.info((Object)("Downloading file from " + packageUrl));
        URL url = null;
        BufferedInputStream urlFileInputStream = null;
        try {
            url = new URL(packageUrl);
            InputStream in = url.openStream();
            urlFileInputStream = new BufferedInputStream(in);
        }
        catch (MalformedURLException e) {
            String errorMsg = "Url " + packageUrl + " is malformed.";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new ProjectManagerException(errorMsg, (Throwable)e);
        }
        catch (IOException e) {
            String errorMsg = "Error opening input stream to " + packageUrl;
            logger.error((Object)errorMsg, (Throwable)e);
            throw new ProjectManagerException(errorMsg, (Throwable)e);
        }
        String filename = this.getFileName(url.getFile());
        File tempDir = Utils.createTempDir();
        OutputStream fileOutputStream = null;
        try {
            try {
                logger.error((Object)("Downloading " + filename));
                File archiveFile = new File(tempDir, filename);
                fileOutputStream = new BufferedOutputStream(new FileOutputStream(archiveFile));
                IOUtils.copy((InputStream)urlFileInputStream, (OutputStream)fileOutputStream);
                logger.error((Object)("Downloaded to " + archiveFile.toString() + " " + archiveFile.length() + " bytes."));
                projectManager.uploadProject(project, archiveFile, "zip", user);
            }
            catch (Exception e) {
                logger.info((Object)"Installation Failed.", (Throwable)e);
                String error = e.getMessage();
                if (error.length() > 512) {
                    error = String.valueOf(error.substring(0, 512)) + "\nToo many errors to display.\n";
                }
                throw new ProjectManagerException("Installation failed: " + error);
            }
        }
        finally {
            if (tempDir.exists()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
            if (urlFileInputStream != null) {
                ((InputStream)urlFileInputStream).close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return Integer.toString(project.getVersion());
    }

    private String getFileName(String file) {
        return file.substring(file.lastIndexOf("/") + 1);
    }
}

