/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.database.AbstractJdbcLoader;
import azkaban.trigger.JdbcTriggerLoader;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerLoader;
import azkaban.trigger.TriggerLoaderException;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcTriggerLoader
extends AbstractJdbcLoader
implements TriggerLoader {
    private static Logger logger = Logger.getLogger(JdbcTriggerLoader.class);
    private AbstractJdbcLoader.EncodingType defaultEncodingType = AbstractJdbcLoader.EncodingType.GZIP;
    private static final String triggerTblName = "triggers";
    private static final String GET_UPDATED_TRIGGERS = "SELECT trigger_id, trigger_source, modify_time, enc_type, data FROM triggers WHERE modify_time>=?";
    private static String GET_ALL_TRIGGERS = "SELECT trigger_id, trigger_source, modify_time, enc_type, data FROM triggers";
    private static String GET_TRIGGER = "SELECT trigger_id, trigger_source, modify_time, enc_type, data FROM triggers WHERE trigger_id=?";
    private static String ADD_TRIGGER = "INSERT INTO triggers ( modify_time) values (?)";
    private static String REMOVE_TRIGGER = "DELETE FROM triggers WHERE trigger_id=?";
    private static String UPDATE_TRIGGER = "UPDATE triggers SET trigger_source=?, modify_time=?, enc_type=?, data=? WHERE trigger_id=?";

    public AbstractJdbcLoader.EncodingType getDefaultEncodingType() {
        return this.defaultEncodingType;
    }

    public void setDefaultEncodingType(AbstractJdbcLoader.EncodingType defaultEncodingType) {
        this.defaultEncodingType = defaultEncodingType;
    }

    public JdbcTriggerLoader(Props props) {
        super(props);
    }

    public List<Trigger> getUpdatedTriggers(long lastUpdateTime) throws TriggerLoaderException {
        List triggers;
        logger.info((Object)("Loading triggers changed since " + new DateTime(lastUpdateTime).toString()));
        Connection connection = this.getConnection();
        QueryRunner runner = new QueryRunner();
        TriggerResultHandler handler = new TriggerResultHandler(this);
        try {
            try {
                triggers = (List)runner.query(connection, "SELECT trigger_id, trigger_source, modify_time, enc_type, data FROM triggers WHERE modify_time>=?", (ResultSetHandler)handler, new Object[]{lastUpdateTime});
            }
            catch (SQLException e) {
                logger.error((Object)(String.valueOf(GET_ALL_TRIGGERS) + " failed."));
                throw new TriggerLoaderException("Loading triggers from db failed. ", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        logger.info((Object)("Loaded " + triggers.size() + " triggers."));
        return triggers;
    }

    public List<Trigger> loadTriggers() throws TriggerLoaderException {
        List triggers;
        logger.info((Object)"Loading all triggers from db.");
        Connection connection = this.getConnection();
        QueryRunner runner = new QueryRunner();
        TriggerResultHandler handler = new TriggerResultHandler(this);
        try {
            try {
                triggers = (List)runner.query(connection, GET_ALL_TRIGGERS, (ResultSetHandler)handler);
            }
            catch (SQLException e) {
                logger.error((Object)(String.valueOf(GET_ALL_TRIGGERS) + " failed."));
                throw new TriggerLoaderException("Loading triggers from db failed. ", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        logger.info((Object)("Loaded " + triggers.size() + " triggers."));
        return triggers;
    }

    public void removeTrigger(Trigger t) throws TriggerLoaderException {
        logger.info((Object)("Removing trigger " + t.toString() + " from db."));
        QueryRunner runner = this.createQueryRunner();
        try {
            int removes = runner.update(REMOVE_TRIGGER, (Object)t.getTriggerId());
            if (removes == 0) {
                throw new TriggerLoaderException("No trigger has been removed.");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(String.valueOf(REMOVE_TRIGGER) + " failed."));
            throw new TriggerLoaderException("Remove trigger " + t.toString() + " from db failed. ", (Throwable)e);
        }
    }

    public void addTrigger(Trigger t) throws TriggerLoaderException {
        logger.info((Object)("Inserting trigger " + t.toString() + " into db."));
        t.setLastModifyTime(System.currentTimeMillis());
        Connection connection = this.getConnection();
        try {
            try {
                this.addTrigger(connection, t, this.defaultEncodingType);
            }
            catch (Exception e) {
                throw new TriggerLoaderException("Error uploading trigger", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private synchronized void addTrigger(Connection connection, Trigger t, AbstractJdbcLoader.EncodingType encType) throws TriggerLoaderException {
        QueryRunner runner = new QueryRunner();
        try {
            runner.update(connection, ADD_TRIGGER, (Object)DateTime.now().getMillis());
            connection.commit();
            long id = (Long)runner.query(connection, LastInsertID.access$1(), (ResultSetHandler)new LastInsertID(null));
            if (id == -1L) {
                logger.error((Object)"trigger id is not properly created.");
                throw new TriggerLoaderException("trigger id is not properly created.");
            }
            t.setTriggerId((int)id);
            this.updateTrigger(t);
            logger.info((Object)("uploaded trigger " + t.getDescription()));
        }
        catch (SQLException e) {
            throw new TriggerLoaderException("Error creating trigger.", (Throwable)e);
        }
    }

    public void updateTrigger(Trigger t) throws TriggerLoaderException {
        logger.info((Object)("Updating trigger " + t.getTriggerId() + " into db."));
        t.setLastModifyTime(System.currentTimeMillis());
        Connection connection = this.getConnection();
        try {
            try {
                this.updateTrigger(connection, t, this.defaultEncodingType);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TriggerLoaderException("Failed to update trigger " + t.toString() + " into db!");
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
    }

    private void updateTrigger(Connection connection, Trigger t, AbstractJdbcLoader.EncodingType encType) throws TriggerLoaderException {
        String json = JSONUtils.toJSON((Object)t.toJson());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == AbstractJdbcLoader.EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes((byte[])stringData);
            }
            logger.debug((Object)("NumChars: " + json.length() + " UTF-8:" + stringData.length + " Gzip:" + data.length));
        }
        catch (IOException e) {
            throw new TriggerLoaderException("Error encoding the trigger " + t.toString());
        }
        QueryRunner runner = new QueryRunner();
        try {
            int updates = runner.update(connection, UPDATE_TRIGGER, new Object[]{t.getSource(), t.getLastModifyTime(), encType.getNumVal(), data, t.getTriggerId()});
            connection.commit();
            if (updates == 0) {
                throw new TriggerLoaderException("No trigger has been updated.");
            }
            logger.info((Object)("Updated " + updates + " records."));
        }
        catch (SQLException e) {
            logger.error((Object)(String.valueOf(UPDATE_TRIGGER) + " failed."));
            throw new TriggerLoaderException("Update trigger " + t.toString() + " into db failed. ", (Throwable)e);
        }
    }

    private Connection getConnection() throws TriggerLoaderException {
        Connection connection = null;
        try {
            connection = super.getDBConnection(false);
        }
        catch (Exception e) {
            DbUtils.closeQuietly((Connection)connection);
            throw new TriggerLoaderException("Error getting DB connection.", (Throwable)e);
        }
        return connection;
    }

    public Trigger loadTrigger(int triggerId) throws TriggerLoaderException {
        List triggers;
        logger.info((Object)("Loading trigger " + triggerId + " from db."));
        Connection connection = this.getConnection();
        QueryRunner runner = new QueryRunner();
        TriggerResultHandler handler = new TriggerResultHandler(this);
        try {
            try {
                triggers = (List)runner.query(connection, GET_TRIGGER, (ResultSetHandler)handler, new Object[]{triggerId});
            }
            catch (SQLException e) {
                logger.error((Object)(String.valueOf(GET_TRIGGER) + " failed."));
                throw new TriggerLoaderException("Loading trigger from db failed. ", (Throwable)e);
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        if (triggers.size() == 0) {
            logger.error((Object)("Loaded 0 triggers. Failed to load trigger " + triggerId));
            throw new TriggerLoaderException("Loaded 0 triggers. Failed to load trigger " + triggerId);
        }
        return (Trigger)triggers.get(0);
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }
}

