/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.servlet;

import azkaban.executor.ExecutionOptions;
import azkaban.utils.JSONUtils;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpRequestUtils {
    public static ExecutionOptions parseFlowOptions(HttpServletRequest req) throws ServletException {
        String disabled;
        String[] emailSplit;
        String emails;
        ExecutionOptions execOptions = new ExecutionOptions();
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"failureAction")) {
            String option = HttpRequestUtils.getParam((HttpServletRequest)req, (String)"failureAction");
            if (option.equals("finishCurrent")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING);
            } else if (option.equals("cancelImmediately")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.CANCEL_ALL);
            } else if (option.equals("finishPossible")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE);
            }
        }
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"failureEmailsOverride")) {
            boolean override = HttpRequestUtils.getBooleanParam((HttpServletRequest)req, (String)"failureEmailsOverride", (boolean)false);
            execOptions.setFailureEmailsOverridden(override);
        }
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"successEmailsOverride")) {
            boolean override = HttpRequestUtils.getBooleanParam((HttpServletRequest)req, (String)"successEmailsOverride", (boolean)false);
            execOptions.setSuccessEmailsOverridden(override);
        }
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"failureEmails") && !(emails = HttpRequestUtils.getParam((HttpServletRequest)req, (String)"failureEmails")).isEmpty()) {
            emailSplit = emails.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            execOptions.setFailureEmails(Arrays.asList(emailSplit));
        }
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"successEmails") && !(emails = HttpRequestUtils.getParam((HttpServletRequest)req, (String)"successEmails")).isEmpty()) {
            emailSplit = emails.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            execOptions.setSuccessEmails(Arrays.asList(emailSplit));
        }
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"notifyFailureFirst")) {
            execOptions.setNotifyOnFirstFailure(Boolean.parseBoolean(HttpRequestUtils.getParam((HttpServletRequest)req, (String)"notifyFailureFirst")));
        }
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"notifyFailureLast")) {
            execOptions.setNotifyOnLastFailure(Boolean.parseBoolean(HttpRequestUtils.getParam((HttpServletRequest)req, (String)"notifyFailureLast")));
        }
        String concurrentOption = "skip";
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"concurrentOption")) {
            concurrentOption = HttpRequestUtils.getParam((HttpServletRequest)req, (String)"concurrentOption");
            execOptions.setConcurrentOption(concurrentOption);
            if (concurrentOption.equals("pipeline")) {
                int pipelineLevel = HttpRequestUtils.getIntParam((HttpServletRequest)req, (String)"pipelineLevel");
                execOptions.setPipelineLevel(Integer.valueOf(pipelineLevel));
            } else if (concurrentOption.equals("queue")) {
                int queueLevel = HttpRequestUtils.getIntParam((HttpServletRequest)req, (String)"queueLevel", (int)1);
                execOptions.setPipelineLevel(Integer.valueOf(queueLevel));
            }
        }
        String mailCreator = "default";
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"mailCreator")) {
            mailCreator = HttpRequestUtils.getParam((HttpServletRequest)req, (String)"mailCreator");
            execOptions.setMailCreator(mailCreator);
        }
        Map flowParamGroup = HttpRequestUtils.getParamGroup((HttpServletRequest)req, (String)"flowOverride");
        execOptions.addAllFlowParameters(flowParamGroup);
        if (HttpRequestUtils.hasParam((HttpServletRequest)req, (String)"disabled") && !(disabled = HttpRequestUtils.getParam((HttpServletRequest)req, (String)"disabled")).isEmpty()) {
            List disabledList = (List)JSONUtils.parseJSONFromStringQuiet((String)disabled);
            execOptions.setDisabledJobs(disabledList);
        }
        return execOptions;
    }

    public static boolean hasParam(HttpServletRequest request, String param) {
        return request.getParameter(param) != null;
    }

    public static String getParam(HttpServletRequest request, String name) throws ServletException {
        String p = request.getParameter(name);
        if (p == null) {
            throw new ServletException("Missing required parameter '" + name + "'.");
        }
        return p;
    }

    public static String getParam(HttpServletRequest request, String name, String defaultVal) {
        String p = request.getParameter(name);
        if (p == null) {
            return defaultVal;
        }
        return p;
    }

    public static int getIntParam(HttpServletRequest request, String name) throws ServletException {
        String p = HttpRequestUtils.getParam((HttpServletRequest)request, (String)name);
        return Integer.parseInt(p);
    }

    public static int getIntParam(HttpServletRequest request, String name, int defaultVal) {
        if (HttpRequestUtils.hasParam((HttpServletRequest)request, (String)name)) {
            try {
                return HttpRequestUtils.getIntParam((HttpServletRequest)request, (String)name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static boolean getBooleanParam(HttpServletRequest request, String name) throws ServletException {
        String p = HttpRequestUtils.getParam((HttpServletRequest)request, (String)name);
        return Boolean.parseBoolean(p);
    }

    public static boolean getBooleanParam(HttpServletRequest request, String name, boolean defaultVal) {
        if (HttpRequestUtils.hasParam((HttpServletRequest)request, (String)name)) {
            try {
                return HttpRequestUtils.getBooleanParam((HttpServletRequest)request, (String)name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static long getLongParam(HttpServletRequest request, String name) throws ServletException {
        String p = HttpRequestUtils.getParam((HttpServletRequest)request, (String)name);
        return Long.valueOf(p);
    }

    public static long getLongParam(HttpServletRequest request, String name, long defaultVal) {
        if (HttpRequestUtils.hasParam((HttpServletRequest)request, (String)name)) {
            try {
                return HttpRequestUtils.getLongParam((HttpServletRequest)request, (String)name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static Map<String, String> getParamGroup(HttpServletRequest request, String groupName) throws ServletException {
        Enumeration enumerate = request.getParameterNames();
        String matchString = String.valueOf(groupName) + "[";
        HashMap<String, String> groupParam = new HashMap<String, String>();
        while (enumerate.hasMoreElements()) {
            String str = (String)enumerate.nextElement();
            if (!str.startsWith(matchString)) continue;
            groupParam.put(str.substring(matchString.length(), str.length() - 1), request.getParameter(str));
        }
        return groupParam;
    }
}

