/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.utils;

import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.UndefinedPropertyException;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class PropsUtilsTest {
    @Test
    public void testGoodResolveProps() throws IOException {
        Props propsGrandParent = new Props();
        Props propsParent = new Props(propsGrandParent);
        Props props = new Props(propsParent);
        props.put("letter", "a");
        propsParent.put("letter", "b");
        propsGrandParent.put("letter", "c");
        Assert.assertEquals((Object)"a", (Object)props.get((Object)"letter"));
        propsParent.put("my", "name");
        propsParent.put("your", "eyes");
        propsGrandParent.put("their", "ears");
        propsGrandParent.put("your", "hair");
        Assert.assertEquals((Object)"name", (Object)props.get((Object)"my"));
        Assert.assertEquals((Object)"eyes", (Object)props.get((Object)"your"));
        Assert.assertEquals((Object)"ears", (Object)props.get((Object)"their"));
        props.put("res1", "${my}");
        props.put("res2", "${their} ${letter}");
        props.put("res7", "${my} ${res5}");
        propsParent.put("res3", "${your} ${their} ${res4}");
        propsGrandParent.put("res4", "${letter}");
        propsGrandParent.put("res5", "${their}");
        propsParent.put("res6", " t ${your} ${your} ${their} ${res5}");
        Props resolved = PropsUtils.resolveProps((Props)props);
        Assert.assertEquals((Object)"name", (Object)resolved.get((Object)"res1"));
        Assert.assertEquals((Object)"ears a", (Object)resolved.get((Object)"res2"));
        Assert.assertEquals((Object)"eyes ears a", (Object)resolved.get((Object)"res3"));
        Assert.assertEquals((Object)"a", (Object)resolved.get((Object)"res4"));
        Assert.assertEquals((Object)"ears", (Object)resolved.get((Object)"res5"));
        Assert.assertEquals((Object)" t eyes eyes ears ears", (Object)resolved.get((Object)"res6"));
        Assert.assertEquals((Object)"name ears", (Object)resolved.get((Object)"res7"));
    }

    @Test
    public void testCyclesResolveProps() throws IOException {
        Props propsGrandParent = new Props();
        Props propsParent = new Props(propsGrandParent);
        Props props = new Props(propsParent);
        props.put("a", "${a}");
        this.failIfNotException(props);
        props.put("a", "${b}");
        props.put("b", "${a}");
        this.failIfNotException(props);
        props.clearLocal();
        props.put("a", "${b}");
        props.put("b", "${c}");
        propsParent.put("d", "${a}");
        this.failIfNotException(props);
        props.clearLocal();
        props.put("a", "testing ${b}");
        props.put("b", "${c}");
        propsGrandParent.put("c", "${d}");
        propsParent.put("d", "${a}");
        this.failIfNotException(props);
        props.clearLocal();
        props.put("a", "testing ${c} ${b}");
        props.put("b", "${c} test");
        propsGrandParent.put("c", "${d}");
        propsParent.put("d", "${a}");
        this.failIfNotException(props);
    }

    private void failIfNotException(Props props) {
        try {
            PropsUtils.resolveProps((Props)props);
            Assert.fail();
        }
        catch (UndefinedPropertyException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

