/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.jobExecutor;

import azkaban.jobExecutor.PythonJob;
import azkaban.test.jobExecutor.Utils;
import azkaban.utils.Props;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PythonJobTest {
    private PythonJob job = null;
    private Props props = null;
    private Logger log = Logger.getLogger(PythonJob.class);
    private static final String scriptContent = "#!/usr/bin/python  \nimport re, string, sys  \n# if no arguments were given, print a helpful message \nl=len(sys.argv) \nif l < 1: \n\tprint 'Usage: celsium --t temp' \n\tsys.exit(1) \n\n# Loop over the arguments \ni=1 \nwhile i < l-1 : \n\tname = sys.argv[i] \n\tvalue = sys.argv[i+1] \n\tif name == \"--t\": \n\t\ttry: \n\t\t\tfahrenheit = float(string.atoi(value)) \n\t\texcept string.atoi_error: \n\t\t\tprint repr(value), \" not a numeric value\" \n\t\telse: \n\t\t\tcelsius=(fahrenheit-32)*5.0/9.0 \n\t\t\tprint '%i F = %iC' % (int(fahrenheit), int(celsius+.5)) \n\t\t\tsys.exit(0) \n\t\ti=i+2\n";
    private static String scriptFile;

    @BeforeClass
    public static void init() {
        long time = new Date().getTime();
        scriptFile = "/tmp/azkaban_python" + time + ".py";
        try {
            Utils.dumpFile((String)scriptFile, (String)scriptContent);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Assert.fail((String)("error in creating script file:" + e.getLocalizedMessage()));
        }
    }

    @AfterClass
    public static void cleanup() {
        Utils.removeFile((String)scriptFile);
    }

    @Test
    public void testPythonJob() {
        this.props = new Props();
        this.props.put("working.dir", ".");
        this.props.put("type", "python");
        this.props.put("script", scriptFile);
        this.props.put("t", "90");
        this.props.put("type", "script");
        this.props.put("fullPath", ".");
        this.job = new PythonJob("TestProcess", this.props, this.props, this.log);
        try {
            this.job.run();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Assert.fail((String)("Python job failed:" + e.getLocalizedMessage()));
        }
    }
}

