/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.CircularBuffer;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogGobbler
extends Thread {
    private final BufferedReader inputReader;
    private final Logger logger;
    private final Level loggingLevel;
    private final CircularBuffer<String> buffer;

    public LogGobbler(Reader inputReader, Logger logger, Level level, int bufferLines) {
        this.inputReader = new BufferedReader(inputReader);
        this.logger = logger;
        this.loggingLevel = level;
        this.buffer = new CircularBuffer(bufferLines);
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                String line = this.inputReader.readLine();
                if (line == null) {
                    return;
                }
                this.buffer.append((Object)line);
                this.log(line);
            }
        }
        catch (IOException e) {
            this.error("Error reading from logging stream:", (Exception)e);
        }
    }

    private void log(String message) {
        if (this.logger != null) {
            this.logger.log((Priority)this.loggingLevel, (Object)message);
        }
    }

    private void error(String message, Exception e) {
        if (this.logger != null) {
            this.logger.error((Object)message, (Throwable)e);
        }
    }

    private void info(String message, Exception e) {
        if (this.logger != null) {
            this.logger.info((Object)message, (Throwable)e);
        }
    }

    public void awaitCompletion(long waitMs) {
        try {
            this.join(waitMs);
        }
        catch (InterruptedException e) {
            this.info("I/O thread interrupted.", (Exception)e);
        }
    }

    public String getRecentLog() {
        return Joiner.on((String)System.getProperty("line.separator")).join((Iterable)this.buffer);
    }
}

