/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobtype;

import azkaban.jobExecutor.Job;
import azkaban.utils.Props;
import java.util.HashMap;
import java.util.Map;

public class JobTypePluginSet {
    private Map<String, Class<? extends Job>> jobToClass;
    private Map<String, Props> pluginJobPropsMap;
    private Map<String, Props> pluginLoadPropsMap;
    private Props commonJobProps;
    private Props commonLoadProps;

    public JobTypePluginSet() {
        this.jobToClass = new HashMap();
        this.pluginJobPropsMap = new HashMap();
        this.pluginLoadPropsMap = new HashMap();
    }

    public JobTypePluginSet(JobTypePluginSet clone) {
        this.jobToClass = new HashMap(clone.jobToClass);
        this.pluginJobPropsMap = new HashMap(clone.pluginJobPropsMap);
        this.pluginLoadPropsMap = new HashMap(clone.pluginLoadPropsMap);
        this.commonJobProps = clone.commonJobProps;
        this.commonLoadProps = clone.commonLoadProps;
    }

    public void setCommonPluginJobProps(Props commonJobProps) {
        this.commonJobProps = commonJobProps;
    }

    public void setCommonPluginLoadProps(Props commonLoadProps) {
        this.commonLoadProps = commonLoadProps;
    }

    public Props getCommonPluginJobProps() {
        return this.commonJobProps;
    }

    public Props getCommonPluginLoadProps() {
        return this.commonLoadProps;
    }

    public Props getPluginLoaderProps(String jobTypeName) {
        return (Props)this.pluginLoadPropsMap.get(jobTypeName);
    }

    public Props getPluginJobProps(String jobTypeName) {
        return (Props)this.pluginJobPropsMap.get(jobTypeName);
    }

    public Class<? extends Job> getPluginClass(String jobTypeName) {
        return (Class)this.jobToClass.get(jobTypeName);
    }

    public void addPluginClass(String jobTypeName, Class<? extends Job> jobTypeClass) {
        this.jobToClass.put(jobTypeName, jobTypeClass);
    }

    public void addPluginJobProps(String jobTypeName, Props props) {
        this.pluginJobPropsMap.put(jobTypeName, props);
    }

    public void addPluginLoadProps(String jobTypeName, Props props) {
        this.pluginLoadPropsMap.put(jobTypeName, props);
    }
}

