/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class Console
extends Tool
implements ActionListener,
MouseListener,
WindowListener,
ShutdownHandler {
    private Frame frame;
    private boolean trayIconUsed;
    private Font font;
    private Button startBrowser;
    private TextField urlText;
    private Object tray;
    private Object trayIcon;
    private Server web;
    private Server tcp;
    private Server pg;
    private boolean isWindows;
    private long lastOpen;

    public static void main(String ... stringArray) throws SQLException {
        new Console().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        SQLException sQLException;
        block44: {
            boolean bl;
            boolean bl2;
            block43: {
                this.isWindows = Utils.getProperty("os.name", "").startsWith("Windows");
                boolean bl3 = false;
                bl2 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = true;
                bl = stringArray != null && stringArray.length > 0;
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                boolean bl8 = false;
                boolean bl9 = false;
                String string5 = "";
                String string6 = "";
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    String string7 = stringArray[i];
                    if (string7 == null) continue;
                    if ("-?".equals(string7) || "-help".equals(string7)) {
                        this.showUsage();
                        return;
                    }
                    if ("-url".equals(string7)) {
                        bl7 = false;
                        string2 = stringArray[++i];
                        continue;
                    }
                    if ("-driver".equals(string7)) {
                        string = stringArray[++i];
                        continue;
                    }
                    if ("-user".equals(string7)) {
                        string3 = stringArray[++i];
                        continue;
                    }
                    if ("-password".equals(string7)) {
                        string4 = stringArray[++i];
                        continue;
                    }
                    if (string7.startsWith("-web")) {
                        if ("-web".equals(string7)) {
                            bl7 = false;
                            bl4 = true;
                            continue;
                        }
                        if ("-webAllowOthers".equals(string7) || "-webDaemon".equals(string7) || "-webSSL".equals(string7)) continue;
                        if ("-webPort".equals(string7)) {
                            ++i;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(string7);
                        continue;
                    }
                    if ("-tool".equals(string7)) {
                        bl7 = false;
                        bl4 = true;
                        bl5 = true;
                        continue;
                    }
                    if ("-browser".equals(string7)) {
                        bl7 = false;
                        bl4 = true;
                        bl6 = true;
                        continue;
                    }
                    if (string7.startsWith("-tcp")) {
                        if ("-tcp".equals(string7)) {
                            bl7 = false;
                            bl3 = true;
                            continue;
                        }
                        if ("-tcpAllowOthers".equals(string7) || "-tcpDaemon".equals(string7) || "-tcpSSL".equals(string7)) continue;
                        if ("-tcpPort".equals(string7)) {
                            ++i;
                            continue;
                        }
                        if ("-tcpPassword".equals(string7)) {
                            string5 = stringArray[++i];
                            continue;
                        }
                        if ("-tcpShutdown".equals(string7)) {
                            bl7 = false;
                            bl8 = true;
                            string6 = stringArray[++i];
                            continue;
                        }
                        if ("-tcpShutdownForce".equals(string7)) {
                            bl9 = true;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(string7);
                        continue;
                    }
                    if (string7.startsWith("-pg")) {
                        if ("-pg".equals(string7)) {
                            bl7 = false;
                            bl2 = true;
                            continue;
                        }
                        if ("-pgAllowOthers".equals(string7) || "-pgDaemon".equals(string7)) continue;
                        if ("-pgPort".equals(string7)) {
                            ++i;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(string7);
                        continue;
                    }
                    if ("-properties".equals(string7)) {
                        ++i;
                        continue;
                    }
                    if ("-trace".equals(string7) || "-ifExists".equals(string7)) continue;
                    if ("-baseDir".equals(string7)) {
                        ++i;
                        continue;
                    }
                    this.showUsageAndThrowUnsupportedOption(string7);
                }
                if (bl7) {
                    bl4 = true;
                    bl5 = true;
                    bl6 = true;
                    bl3 = true;
                    bl2 = true;
                }
                if (bl8) {
                    this.out.println("Shutting down TCP Server at " + string6);
                    Server.shutdownTcpServer(string6, string5, bl9, false);
                }
                sQLException = null;
                boolean bl10 = false;
                if (string2 != null) {
                    Connection connection = JdbcUtils.getConnection(string, string2, string3, string4);
                    Server.startWebServer(connection);
                }
                if (bl4) {
                    try {
                        this.web = Server.createWebServer(stringArray);
                        this.web.setShutdownHandler(this);
                        this.web.start();
                        if (bl) {
                            this.out.println(this.web.getStatus());
                        }
                        bl10 = true;
                    }
                    catch (SQLException sQLException2) {
                        this.printProblem(sQLException2, this.web);
                        sQLException = sQLException2;
                    }
                }
                if (bl5 && bl10 && !GraphicsEnvironment.isHeadless()) {
                    this.loadFont();
                    try {
                        if (!this.createTrayIcon()) {
                            this.showWindow();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (bl6 && this.web != null) {
                    this.openBrowser(this.web.getURL());
                }
                if (bl3) {
                    try {
                        this.tcp = Server.createTcpServer(stringArray);
                        this.tcp.start();
                        if (bl) {
                            this.out.println(this.tcp.getStatus());
                        }
                        this.tcp.setShutdownHandler(this);
                    }
                    catch (SQLException sQLException3) {
                        this.printProblem(sQLException3, this.tcp);
                        if (sQLException != null) break block43;
                        sQLException = sQLException3;
                    }
                }
            }
            if (bl2) {
                try {
                    this.pg = Server.createPgServer(stringArray);
                    this.pg.start();
                    if (bl) {
                        this.out.println(this.pg.getStatus());
                    }
                }
                catch (SQLException sQLException4) {
                    this.printProblem(sQLException4, this.pg);
                    if (sQLException != null) break block44;
                    sQLException = sQLException4;
                }
            }
        }
        if (sQLException != null) {
            this.shutdown();
            throw sQLException;
        }
    }

    private void printProblem(Exception exception, Server server) {
        if (server == null) {
            exception.printStackTrace();
        } else {
            this.out.println(server.getStatus());
            this.out.println("Root cause: " + exception.getMessage());
        }
    }

    private static Image loadImage(String string) {
        try {
            byte[] byArray = Utils.getResource(string);
            if (byArray == null) {
                return null;
            }
            return Toolkit.getDefaultToolkit().createImage(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        if (this.trayIconUsed) {
            try {
                Utils.callMethod(this.tray, "remove", this.trayIcon);
            }
            catch (Exception exception) {
            }
            finally {
                this.trayIcon = null;
                this.tray = null;
                this.trayIconUsed = false;
            }
            System.gc();
        }
    }

    private void loadFont() {
        this.font = this.isWindows ? new Font("Dialog", 0, 11) : new Font("Dialog", 0, 12);
    }

    private boolean createTrayIcon() {
        try {
            boolean bl = (Boolean)Utils.callStaticMethod("java.awt.SystemTray.isSupported", new Object[0]);
            if (!bl) {
                return false;
            }
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("H2 Console");
            menuItem.setActionCommand("console");
            menuItem.addActionListener(this);
            menuItem.setFont(this.font);
            popupMenu.add(menuItem);
            MenuItem menuItem2 = new MenuItem("Status");
            menuItem2.setActionCommand("status");
            menuItem2.addActionListener(this);
            menuItem2.setFont(this.font);
            popupMenu.add(menuItem2);
            MenuItem menuItem3 = new MenuItem("Exit");
            menuItem3.setFont(this.font);
            menuItem3.setActionCommand("exit");
            menuItem3.addActionListener(this);
            popupMenu.add(menuItem3);
            this.tray = Utils.callStaticMethod("java.awt.SystemTray.getSystemTray", new Object[0]);
            Dimension dimension = (Dimension)Utils.callMethod(this.tray, "getTrayIconSize", new Object[0]);
            String string = dimension.width >= 24 && dimension.height >= 24 ? "/org/h2/res/h2-24.png" : (dimension.width >= 22 && dimension.height >= 22 ? "/org/h2/res/h2-64-t.png" : "/org/h2/res/h2.png");
            Image image = Console.loadImage(string);
            this.trayIcon = Utils.newInstance("java.awt.TrayIcon", image, "H2 Database Engine", popupMenu);
            Utils.callMethod(this.trayIcon, "addMouseListener", this);
            Utils.callMethod(this.tray, "add", this.trayIcon);
            this.trayIconUsed = true;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void showWindow() {
        if (this.frame != null) {
            return;
        }
        this.frame = new Frame("H2 Console");
        this.frame.addWindowListener(this);
        Image image = Console.loadImage("/org/h2/res/h2.png");
        if (image != null) {
            this.frame.setIconImage(image);
        }
        this.frame.setResizable(false);
        this.frame.setBackground(SystemColor.control);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.frame.setLayout(gridBagLayout);
        Panel panel = new Panel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 13;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(this.font);
        panel.add((Component)label, gridBagConstraints4);
        this.urlText = new TextField();
        this.urlText.setEditable(false);
        this.urlText.setFont(this.font);
        this.urlText.setText(this.web.getURL());
        if (this.isWindows) {
            this.urlText.setFocusable(false);
        }
        panel.add((Component)this.urlText, gridBagConstraints3);
        this.startBrowser = new Button("Start Browser");
        this.startBrowser.setFocusable(false);
        this.startBrowser.setActionCommand("console");
        this.startBrowser.addActionListener(this);
        this.startBrowser.setFont(this.font);
        panel.add((Component)this.startBrowser, gridBagConstraints2);
        this.frame.add((Component)panel, gridBagConstraints);
        int n = 300;
        int n2 = 120;
        this.frame.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        try {
            this.frame.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.frame.setAlwaysOnTop(true);
            this.frame.setAlwaysOnTop(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            String string = this.web.getURL();
            if (this.urlText != null) {
                this.urlText.setText(string);
            }
            long l = System.currentTimeMillis();
            if (this.lastOpen == 0L || this.lastOpen + 100L < l) {
                this.lastOpen = l;
                this.openBrowser(string);
            }
        }
    }

    private void openBrowser(String string) {
        try {
            Server.openBrowser(string);
        }
        catch (Exception exception) {
            this.out.println(exception.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("exit".equals(string)) {
            this.shutdown();
        } else if ("console".equals(string)) {
            this.startBrowser();
        } else if ("status".equals(string)) {
            this.showWindow();
        } else if (this.startBrowser == actionEvent.getSource()) {
            this.startBrowser();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.startBrowser();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.trayIconUsed) {
            this.frame.dispose();
            this.frame = null;
        } else {
            this.shutdown();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

