/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.execapp;

import azkaban.execapp.FlowRunner;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventListener;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.jobtype.JobTypeManager;
import azkaban.project.Project;
import azkaban.project.ProjectLoader;
import azkaban.test.execapp.EventCollectorListener;
import azkaban.test.execapp.MockExecutorLoader;
import azkaban.test.execapp.MockProjectLoader;
import azkaban.test.executor.InteractiveTestJob;
import azkaban.test.executor.JavaJob;
import azkaban.utils.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FlowRunnerTest {
    private File workingDir;
    private JobTypeManager jobtypeManager;
    private ProjectLoader fakeProjectLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        System.out.println("Create temp dir");
        FlowRunnerTest flowRunnerTest = this;
        synchronized (flowRunnerTest) {
            this.workingDir = new File("_AzkabanTestDir_" + System.currentTimeMillis());
            if (this.workingDir.exists()) {
                FileUtils.deleteDirectory((File)this.workingDir);
            }
            this.workingDir.mkdirs();
        }
        this.jobtypeManager = new JobTypeManager(null, this.getClass().getClassLoader());
        this.jobtypeManager.registerJobType("java", JavaJob.class);
        this.jobtypeManager.registerJobType("test", InteractiveTestJob.class);
        this.fakeProjectLoader = new MockProjectLoader(this.workingDir);
        InteractiveTestJob.clearTestJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws IOException {
        System.out.println("Teardown temp dir");
        FlowRunnerTest flowRunnerTest = this;
        synchronized (flowRunnerTest) {
            if (this.workingDir != null) {
                FileUtils.deleteDirectory((File)this.workingDir);
                this.workingDir = null;
            }
        }
    }

    @Test
    public void exec1Normal() throws Exception {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        eventCollector.setEventFilterOut(new Event.Type[]{Event.Type.JOB_FINISHED, Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED});
        FlowRunner runner = this.createFlowRunner((ExecutorLoader)loader, eventCollector, "exec1");
        Assert.assertTrue((!runner.isKilled() ? 1 : 0) != 0);
        runner.run();
        ExecutableFlow exFlow = runner.getExecutableFlow();
        Assert.assertTrue((exFlow.getStatus() == Status.SUCCEEDED ? 1 : 0) != 0);
        this.compareFinishedRuntime(runner);
        this.testStatus(exFlow, "job1", Status.SUCCEEDED);
        this.testStatus(exFlow, "job2", Status.SUCCEEDED);
        this.testStatus(exFlow, "job3", Status.SUCCEEDED);
        this.testStatus(exFlow, "job4", Status.SUCCEEDED);
        this.testStatus(exFlow, "job5", Status.SUCCEEDED);
        this.testStatus(exFlow, "job6", Status.SUCCEEDED);
        this.testStatus(exFlow, "job7", Status.SUCCEEDED);
        this.testStatus(exFlow, "job8", Status.SUCCEEDED);
        this.testStatus(exFlow, "job10", Status.SUCCEEDED);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.FLOW_STARTED, Event.Type.FLOW_FINISHED});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void exec1Disabled() throws Exception {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        eventCollector.setEventFilterOut(new Event.Type[]{Event.Type.JOB_FINISHED, Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED});
        File testDir = new File("unit/executions/exectest1");
        ExecutableFlow exFlow = this.prepareExecDir(testDir, "exec1", 1);
        exFlow.getExecutableNode("job1").setStatus(Status.DISABLED);
        exFlow.getExecutableNode("job6").setStatus(Status.DISABLED);
        exFlow.getExecutableNode("job5").setStatus(Status.DISABLED);
        exFlow.getExecutableNode("job10").setStatus(Status.DISABLED);
        FlowRunner runner = this.createFlowRunner(exFlow, (ExecutorLoader)loader, eventCollector);
        Assert.assertTrue((!runner.isKilled() ? 1 : 0) != 0);
        Assert.assertTrue((exFlow.getStatus() == Status.READY ? 1 : 0) != 0);
        runner.run();
        exFlow = runner.getExecutableFlow();
        this.compareFinishedRuntime(runner);
        Assert.assertTrue((exFlow.getStatus() == Status.SUCCEEDED ? 1 : 0) != 0);
        this.testStatus(exFlow, "job1", Status.SKIPPED);
        this.testStatus(exFlow, "job2", Status.SUCCEEDED);
        this.testStatus(exFlow, "job3", Status.SUCCEEDED);
        this.testStatus(exFlow, "job4", Status.SUCCEEDED);
        this.testStatus(exFlow, "job5", Status.SKIPPED);
        this.testStatus(exFlow, "job6", Status.SKIPPED);
        this.testStatus(exFlow, "job7", Status.SUCCEEDED);
        this.testStatus(exFlow, "job8", Status.SUCCEEDED);
        this.testStatus(exFlow, "job10", Status.SKIPPED);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.FLOW_STARTED, Event.Type.FLOW_FINISHED});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void exec1Failed() throws Exception {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        eventCollector.setEventFilterOut(new Event.Type[]{Event.Type.JOB_FINISHED, Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED});
        File testDir = new File("unit/executions/exectest1");
        ExecutableFlow flow = this.prepareExecDir(testDir, "exec2", 1);
        FlowRunner runner = this.createFlowRunner(flow, (ExecutorLoader)loader, eventCollector);
        runner.run();
        ExecutableFlow exFlow = runner.getExecutableFlow();
        Assert.assertTrue((!runner.isKilled() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Flow status " + exFlow.getStatus()), (exFlow.getStatus() == Status.FAILED ? 1 : 0) != 0);
        this.testStatus(exFlow, "job1", Status.SUCCEEDED);
        this.testStatus(exFlow, "job2d", Status.FAILED);
        this.testStatus(exFlow, "job3", Status.CANCELLED);
        this.testStatus(exFlow, "job4", Status.CANCELLED);
        this.testStatus(exFlow, "job5", Status.CANCELLED);
        this.testStatus(exFlow, "job6", Status.SUCCEEDED);
        this.testStatus(exFlow, "job7", Status.CANCELLED);
        this.testStatus(exFlow, "job8", Status.CANCELLED);
        this.testStatus(exFlow, "job9", Status.CANCELLED);
        this.testStatus(exFlow, "job10", Status.CANCELLED);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.FLOW_STARTED, Event.Type.FLOW_FINISHED});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exec1FailedKillAll() throws Exception {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        eventCollector.setEventFilterOut(new Event.Type[]{Event.Type.JOB_FINISHED, Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED});
        File testDir = new File("unit/executions/exectest1");
        ExecutableFlow flow = this.prepareExecDir(testDir, "exec2", 1);
        flow.getExecutionOptions().setFailureAction(ExecutionOptions.FailureAction.CANCEL_ALL);
        FlowRunner runner = this.createFlowRunner(flow, (ExecutorLoader)loader, eventCollector);
        runner.run();
        ExecutableFlow exFlow = runner.getExecutableFlow();
        Assert.assertTrue((boolean)runner.isKilled());
        Assert.assertTrue((String)("Expected flow " + Status.FAILED + " instead " + exFlow.getStatus()), (exFlow.getStatus() == Status.FAILED ? 1 : 0) != 0);
        FlowRunnerTest flowRunnerTest = this;
        synchronized (flowRunnerTest) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.testStatus(exFlow, "job1", Status.SUCCEEDED);
        this.testStatus(exFlow, "job2d", Status.FAILED);
        this.testStatus(exFlow, "job3", Status.CANCELLED);
        this.testStatus(exFlow, "job4", Status.CANCELLED);
        this.testStatus(exFlow, "job5", Status.CANCELLED);
        this.testStatus(exFlow, "job6", Status.KILLED);
        this.testStatus(exFlow, "job7", Status.CANCELLED);
        this.testStatus(exFlow, "job8", Status.CANCELLED);
        this.testStatus(exFlow, "job9", Status.CANCELLED);
        this.testStatus(exFlow, "job10", Status.CANCELLED);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.FLOW_STARTED, Event.Type.FLOW_FINISHED});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            eventCollector.writeAllEvents();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exec1FailedFinishRest() throws Exception {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        eventCollector.setEventFilterOut(new Event.Type[]{Event.Type.JOB_FINISHED, Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED});
        File testDir = new File("unit/executions/exectest1");
        ExecutableFlow flow = this.prepareExecDir(testDir, "exec3", 1);
        flow.getExecutionOptions().setFailureAction(ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE);
        FlowRunner runner = this.createFlowRunner(flow, (ExecutorLoader)loader, eventCollector);
        runner.run();
        ExecutableFlow exFlow = runner.getExecutableFlow();
        Assert.assertTrue((String)("Expected flow " + Status.FAILED + " instead " + exFlow.getStatus()), (exFlow.getStatus() == Status.FAILED ? 1 : 0) != 0);
        FlowRunnerTest flowRunnerTest = this;
        synchronized (flowRunnerTest) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.testStatus(exFlow, "job1", Status.SUCCEEDED);
        this.testStatus(exFlow, "job2d", Status.FAILED);
        this.testStatus(exFlow, "job3", Status.SUCCEEDED);
        this.testStatus(exFlow, "job4", Status.CANCELLED);
        this.testStatus(exFlow, "job5", Status.CANCELLED);
        this.testStatus(exFlow, "job6", Status.CANCELLED);
        this.testStatus(exFlow, "job7", Status.SUCCEEDED);
        this.testStatus(exFlow, "job8", Status.SUCCEEDED);
        this.testStatus(exFlow, "job9", Status.SUCCEEDED);
        this.testStatus(exFlow, "job10", Status.CANCELLED);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.FLOW_STARTED, Event.Type.FLOW_FINISHED});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            eventCollector.writeAllEvents();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void execAndCancel() throws Exception {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        eventCollector.setEventFilterOut(new Event.Type[]{Event.Type.JOB_FINISHED, Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED});
        FlowRunner runner = this.createFlowRunner((ExecutorLoader)loader, eventCollector, "exec1");
        Assert.assertTrue((!runner.isKilled() ? 1 : 0) != 0);
        Thread thread = new Thread((Runnable)runner);
        thread.start();
        FlowRunnerTest flowRunnerTest = this;
        synchronized (flowRunnerTest) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            runner.kill("me");
            Assert.assertTrue((boolean)runner.isKilled());
        }
        flowRunnerTest = this;
        synchronized (flowRunnerTest) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ExecutableFlow exFlow = runner.getExecutableFlow();
        this.testStatus(exFlow, "job1", Status.SUCCEEDED);
        this.testStatus(exFlow, "job2", Status.SUCCEEDED);
        this.testStatus(exFlow, "job5", Status.CANCELLED);
        this.testStatus(exFlow, "job7", Status.CANCELLED);
        this.testStatus(exFlow, "job8", Status.CANCELLED);
        this.testStatus(exFlow, "job10", Status.CANCELLED);
        this.testStatus(exFlow, "job3", Status.KILLED);
        this.testStatus(exFlow, "job4", Status.KILLED);
        this.testStatus(exFlow, "job6", Status.KILLED);
        Assert.assertTrue((String)("Expected FAILED status instead got " + exFlow.getStatus()), (exFlow.getStatus() == Status.KILLED ? 1 : 0) != 0);
        try {
            eventCollector.checkEventExists(new Event.Type[]{Event.Type.FLOW_STARTED, Event.Type.FLOW_FINISHED});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            eventCollector.writeAllEvents();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void execRetries() throws Exception {
        MockExecutorLoader loader = new MockExecutorLoader();
        EventCollectorListener eventCollector = new EventCollectorListener();
        eventCollector.setEventFilterOut(new Event.Type[]{Event.Type.JOB_FINISHED, Event.Type.JOB_STARTED, Event.Type.JOB_STATUS_CHANGED});
        FlowRunner runner = this.createFlowRunner((ExecutorLoader)loader, eventCollector, "exec4-retry");
        runner.run();
        ExecutableFlow exFlow = runner.getExecutableFlow();
        this.testStatus(exFlow, "job-retry", Status.SUCCEEDED);
        this.testStatus(exFlow, "job-pass", Status.SUCCEEDED);
        this.testStatus(exFlow, "job-retry-fail", Status.FAILED);
        this.testAttempts(exFlow, "job-retry", 3);
        this.testAttempts(exFlow, "job-pass", 0);
        this.testAttempts(exFlow, "job-retry-fail", 2);
        Assert.assertTrue((String)("Expected FAILED status instead got " + exFlow.getStatus()), (exFlow.getStatus() == Status.FAILED ? 1 : 0) != 0);
    }

    private void testStatus(ExecutableFlow flow, String name, Status status) {
        ExecutableNode node = flow.getExecutableNode(name);
        if (node.getStatus() != status) {
            Assert.fail((String)("Status of job " + node.getId() + " is " + node.getStatus() + " not " + status + " as expected."));
        }
    }

    private void testAttempts(ExecutableFlow flow, String name, int attempt) {
        ExecutableNode node = flow.getExecutableNode(name);
        if (node.getAttempt() != attempt) {
            Assert.fail((String)("Expected " + attempt + " got " + node.getAttempt() + " attempts " + name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutableFlow prepareExecDir(File execDir, String flowName, int execId) throws IOException {
        FlowRunnerTest flowRunnerTest = this;
        synchronized (flowRunnerTest) {
            FileUtils.copyDirectory((File)execDir, (File)this.workingDir);
        }
        File jsonFlowFile = new File(this.workingDir, String.valueOf(flowName) + ".flow");
        HashMap flowObj = (HashMap)JSONUtils.parseJSONFromFile((File)jsonFlowFile);
        Project project = new Project(1, "myproject");
        project.setVersion(2);
        Flow flow = Flow.flowFromObject((Object)flowObj);
        ExecutableFlow execFlow = new ExecutableFlow(project, flow);
        execFlow.setExecutionId(execId);
        execFlow.setExecutionPath(this.workingDir.getPath());
        return execFlow;
    }

    private void compareFinishedRuntime(FlowRunner runner) throws Exception {
        ExecutableFlow flow = runner.getExecutableFlow();
        for (String flowName : flow.getStartNodes()) {
            ExecutableNode node = flow.getExecutableNode(flowName);
            this.compareStartFinishTimes(flow, node, 0L);
        }
    }

    private void compareStartFinishTimes(ExecutableFlow flow, ExecutableNode node, long previousEndTime) throws Exception {
        long startTime = node.getStartTime();
        long endTime = node.getEndTime();
        if (startTime <= 0L) {
            Assert.assertTrue((endTime <= 0L ? 1 : 0) != 0);
            return;
        }
        Assert.assertTrue((String)"Checking start and end times", (startTime > 0L && endTime >= startTime ? 1 : 0) != 0);
        Assert.assertTrue((String)("Start time for " + node.getId() + " is " + startTime + " and less than " + previousEndTime), (startTime >= previousEndTime ? 1 : 0) != 0);
        for (String outNode : node.getOutNodes()) {
            ExecutableNode childNode = flow.getExecutableNode(outNode);
            this.compareStartFinishTimes(flow, childNode, endTime);
        }
    }

    private FlowRunner createFlowRunner(ExecutableFlow flow, ExecutorLoader loader, EventCollectorListener eventCollector) throws Exception {
        loader.uploadExecutableFlow(flow);
        FlowRunner runner = new FlowRunner(flow, loader, this.fakeProjectLoader, this.jobtypeManager);
        runner.addListener((EventListener)eventCollector);
        return runner;
    }

    private FlowRunner createFlowRunner(ExecutorLoader loader, EventCollectorListener eventCollector, String flowName) throws Exception {
        File testDir = new File("unit/executions/exectest1");
        ExecutableFlow exFlow = this.prepareExecDir(testDir, flowName, 1);
        loader.uploadExecutableFlow(exFlow);
        FlowRunner runner = new FlowRunner(exFlow, loader, this.fakeProjectLoader, this.jobtypeManager);
        runner.addListener((EventListener)eventCollector);
        return runner;
    }
}

