/*
 * Decompiled with CFR 0.152.
 */
package azkaban.test.execapp;

import azkaban.execapp.FlowRunner;
import azkaban.execapp.event.EventListener;
import azkaban.execapp.event.FlowWatcher;
import azkaban.execapp.event.LocalFlowWatcher;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.jobtype.JobTypeManager;
import azkaban.project.Project;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectManagerException;
import azkaban.test.execapp.EventCollectorListener;
import azkaban.test.execapp.FlowRunnerTest2;
import azkaban.test.execapp.MockExecutorLoader;
import azkaban.test.execapp.MockProjectLoader;
import azkaban.test.executor.InteractiveTestJob;
import azkaban.test.executor.JavaJob;
import azkaban.utils.DirectoryFlowLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FlowRunnerPipelineTest {
    private File workingDir;
    private JobTypeManager jobtypeManager;
    private ProjectLoader fakeProjectLoader;
    private ExecutorLoader fakeExecutorLoader;
    private Logger logger = Logger.getLogger(FlowRunnerTest2.class);
    private Project project;
    private Map<String, Flow> flowMap;
    private static int id = 101;

    @Before
    public void setUp() throws Exception {
        System.out.println("Create temp dir");
        this.workingDir = new File("_AzkabanTestDir_" + System.currentTimeMillis());
        if (this.workingDir.exists()) {
            FileUtils.deleteDirectory((File)this.workingDir);
        }
        this.workingDir.mkdirs();
        this.jobtypeManager = new JobTypeManager(null, this.getClass().getClassLoader());
        this.jobtypeManager.registerJobType("java", JavaJob.class);
        this.jobtypeManager.registerJobType("test", InteractiveTestJob.class);
        this.fakeProjectLoader = new MockProjectLoader(this.workingDir);
        this.fakeExecutorLoader = new MockExecutorLoader();
        this.project = new Project(1, "testProject");
        File dir = new File("unit/executions/embedded2");
        this.prepareProject(dir);
        InteractiveTestJob.clearTestJobs();
    }

    @After
    public void tearDown() throws IOException {
        System.out.println("Teardown temp dir");
        if (this.workingDir != null) {
            FileUtils.deleteDirectory((File)this.workingDir);
            this.workingDir = null;
        }
    }

    @Test
    public void testBasicPipelineLevel1Run() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner previousRunner = this.createFlowRunner(eventCollector, "jobf", "prev");
        ExecutionOptions options = new ExecutionOptions();
        options.setPipelineExecutionId(Integer.valueOf(previousRunner.getExecutableFlow().getExecutionId()));
        options.setPipelineLevel(Integer.valueOf(1));
        LocalFlowWatcher watcher = new LocalFlowWatcher(previousRunner);
        FlowRunner pipelineRunner = this.createFlowRunner(eventCollector, "jobf", "pipe", options);
        pipelineRunner.setFlowWatcher((FlowWatcher)watcher);
        HashMap<String, Status> previousExpectedStateMap = new HashMap<String, Status>();
        HashMap<String, Status> pipelineExpectedStateMap = new HashMap<String, Status>();
        HashMap previousNodeMap = new HashMap();
        HashMap pipelineNodeMap = new HashMap();
        ExecutableFlow pipelineFlow = pipelineRunner.getExecutableFlow();
        ExecutableFlow previousFlow = previousRunner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)previousFlow, previousExpectedStateMap, previousNodeMap);
        this.createExpectedStateMap((ExecutableFlowBase)pipelineFlow, pipelineExpectedStateMap, pipelineNodeMap);
        Thread thread1 = this.runFlowRunnerInThread(previousRunner);
        this.pause(250L);
        Thread thread2 = this.runFlowRunnerInThread(pipelineRunner);
        this.pause(500L);
        previousExpectedStateMap.put("joba", Status.RUNNING);
        previousExpectedStateMap.put("joba1", Status.RUNNING);
        pipelineExpectedStateMap.put("joba", Status.QUEUED);
        pipelineExpectedStateMap.put("joba1", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:joba").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("joba", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobb", Status.RUNNING);
        previousExpectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        previousExpectedStateMap.put("jobd", Status.RUNNING);
        previousExpectedStateMap.put("jobc", Status.RUNNING);
        previousExpectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        pipelineExpectedStateMap.put("joba", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:jobb:innerJobA").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        previousExpectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:joba").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("joba", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobb", Status.RUNNING);
        pipelineExpectedStateMap.put("jobd", Status.RUNNING);
        pipelineExpectedStateMap.put("jobc", Status.QUEUED);
        pipelineExpectedStateMap.put("jobd:innerJobA", Status.QUEUED);
        pipelineExpectedStateMap.put("jobb:innerJobA", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:jobd:innerJobA").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobd:innerFlow2", Status.RUNNING);
        pipelineExpectedStateMap.put("jobd:innerJobA", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:jobd:innerFlow2").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("jobd:innerFlow2", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobd", Status.SUCCEEDED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:jobb:innerJobB").succeedJob();
        InteractiveTestJob.getTestJob((String)"prev:jobb:innerJobC").succeedJob();
        InteractiveTestJob.getTestJob((String)"prev:jobc").succeedJob();
        this.pause(250L);
        InteractiveTestJob.getTestJob((String)"pipe:jobb:innerJobA").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("jobb:innerJobB", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobb:innerFlow", Status.RUNNING);
        previousExpectedStateMap.put("jobc", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobb:innerJobA", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobc", Status.RUNNING);
        pipelineExpectedStateMap.put("jobb:innerJobB", Status.RUNNING);
        pipelineExpectedStateMap.put("jobb:innerJobC", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:jobb:innerFlow").succeedJob();
        InteractiveTestJob.getTestJob((String)"pipe:jobc").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("jobb:innerFlow", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobb", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobe", Status.RUNNING);
        pipelineExpectedStateMap.put("jobc", Status.SUCCEEDED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:jobb:innerJobB").succeedJob();
        InteractiveTestJob.getTestJob((String)"pipe:jobb:innerJobC").succeedJob();
        InteractiveTestJob.getTestJob((String)"prev:jobe").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("jobe", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobb:innerJobB", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobb:innerJobC", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobb:innerFlow", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:jobd:innerJobA").succeedJob();
        InteractiveTestJob.getTestJob((String)"pipe:jobb:innerFlow").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("jobb", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobd:innerJobA", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobb:innerFlow", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobd:innerFlow2", Status.RUNNING);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:jobd:innerFlow2").succeedJob();
        InteractiveTestJob.getTestJob((String)"prev:joba1").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("jobd:innerFlow2", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobd", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobf", Status.RUNNING);
        previousExpectedStateMap.put("joba1", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("joba1", Status.RUNNING);
        pipelineExpectedStateMap.put("jobe", Status.RUNNING);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:jobe").succeedJob();
        InteractiveTestJob.getTestJob((String)"prev:jobf").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("jobe", Status.SUCCEEDED);
        previousExpectedStateMap.put("jobf", Status.SUCCEEDED);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)previousFlow.getStatus());
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:joba1").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("joba1", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("jobf", Status.RUNNING);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:jobf").succeedJob();
        this.pause(250L);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)pipelineFlow.getStatus());
        Assert.assertFalse((boolean)thread1.isAlive());
        Assert.assertFalse((boolean)thread2.isAlive());
    }

    @Test
    public void testBasicPipelineLevel2Run() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner previousRunner = this.createFlowRunner(eventCollector, "pipelineFlow", "prev");
        ExecutionOptions options = new ExecutionOptions();
        options.setPipelineExecutionId(Integer.valueOf(previousRunner.getExecutableFlow().getExecutionId()));
        options.setPipelineLevel(Integer.valueOf(2));
        LocalFlowWatcher watcher = new LocalFlowWatcher(previousRunner);
        FlowRunner pipelineRunner = this.createFlowRunner(eventCollector, "pipelineFlow", "pipe", options);
        pipelineRunner.setFlowWatcher((FlowWatcher)watcher);
        HashMap<String, Status> previousExpectedStateMap = new HashMap<String, Status>();
        HashMap<String, Status> pipelineExpectedStateMap = new HashMap<String, Status>();
        HashMap previousNodeMap = new HashMap();
        HashMap pipelineNodeMap = new HashMap();
        ExecutableFlow pipelineFlow = pipelineRunner.getExecutableFlow();
        ExecutableFlow previousFlow = previousRunner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)previousFlow, previousExpectedStateMap, previousNodeMap);
        this.createExpectedStateMap((ExecutableFlowBase)pipelineFlow, pipelineExpectedStateMap, pipelineNodeMap);
        Thread thread1 = this.runFlowRunnerInThread(previousRunner);
        this.pause(250L);
        Thread thread2 = this.runFlowRunnerInThread(pipelineRunner);
        this.pause(250L);
        previousExpectedStateMap.put("pipeline1", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipeline1").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipeline1", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipeline2", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipeline2").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipeline2", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3", Status.RUNNING);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobA", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline1").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline1", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline2", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipelineEmbeddedFlow3:innerJobA").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobA", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobB", Status.RUNNING);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobC", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline2", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline2").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline2", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3", Status.RUNNING);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobA", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipelineEmbeddedFlow3:innerJobB").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobB", Status.SUCCEEDED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipelineEmbeddedFlow3:innerJobC").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerFlow", Status.RUNNING);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobC", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobA", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipelineEmbeddedFlow3:innerJobA").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobA", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobC", Status.QUEUED);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobB", Status.QUEUED);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerFlow", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipelineEmbeddedFlow3:innerFlow").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3:innerFlow", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipelineEmbeddedFlow3", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipeline4", Status.RUNNING);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobC", Status.RUNNING);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobB", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipelineEmbeddedFlow3:innerJobB").succeedJob();
        InteractiveTestJob.getTestJob((String)"pipe:pipelineEmbeddedFlow3:innerJobC").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobC", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerJobB", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerFlow", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipeline4").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipeline4", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipelineFlow", Status.RUNNING);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerFlow", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipelineFlow").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipelineFlow", Status.SUCCEEDED);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)previousFlow.getStatus());
        Assert.assertFalse((boolean)thread1.isAlive());
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipelineEmbeddedFlow3:innerFlow").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3:innerFlow", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipelineEmbeddedFlow3", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline4", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline4").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline4", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipelineFlow", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipelineFlow").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipelineFlow", Status.SUCCEEDED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)pipelineFlow.getStatus());
        Assert.assertFalse((boolean)thread2.isAlive());
    }

    @Test
    public void testBasicPipelineLevel2Run2() throws Exception {
        EventCollectorListener eventCollector = new EventCollectorListener();
        FlowRunner previousRunner = this.createFlowRunner(eventCollector, "pipeline1_2", "prev");
        ExecutionOptions options = new ExecutionOptions();
        options.setPipelineExecutionId(Integer.valueOf(previousRunner.getExecutableFlow().getExecutionId()));
        options.setPipelineLevel(Integer.valueOf(2));
        LocalFlowWatcher watcher = new LocalFlowWatcher(previousRunner);
        FlowRunner pipelineRunner = this.createFlowRunner(eventCollector, "pipeline1_2", "pipe", options);
        pipelineRunner.setFlowWatcher((FlowWatcher)watcher);
        HashMap<String, Status> previousExpectedStateMap = new HashMap<String, Status>();
        HashMap<String, Status> pipelineExpectedStateMap = new HashMap<String, Status>();
        HashMap previousNodeMap = new HashMap();
        HashMap pipelineNodeMap = new HashMap();
        ExecutableFlow pipelineFlow = pipelineRunner.getExecutableFlow();
        ExecutableFlow previousFlow = previousRunner.getExecutableFlow();
        this.createExpectedStateMap((ExecutableFlowBase)previousFlow, previousExpectedStateMap, previousNodeMap);
        this.createExpectedStateMap((ExecutableFlowBase)pipelineFlow, pipelineExpectedStateMap, pipelineNodeMap);
        Thread thread1 = this.runFlowRunnerInThread(previousRunner);
        this.pause(250L);
        Thread thread2 = this.runFlowRunnerInThread(pipelineRunner);
        this.pause(250L);
        previousExpectedStateMap.put("pipeline1_1", Status.RUNNING);
        previousExpectedStateMap.put("pipeline1_1:innerJobA", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1_1", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1_1:innerJobA", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipeline1_1:innerJobA").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipeline1_1:innerJobA", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipeline1_1:innerFlow2", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipeline1_1:innerFlow2").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipeline1_1", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipeline1_1:innerFlow2", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipeline1_2", Status.RUNNING);
        previousExpectedStateMap.put("pipeline1_2:innerJobA", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1_1:innerJobA", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline1_1:innerJobA").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline1_1:innerJobA", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline1_1:innerFlow2", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipeline1_2:innerJobA").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipeline1_2:innerJobA", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipeline1_2:innerFlow2", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1_1:innerFlow2", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline1_1:innerFlow2").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline1_1", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline1_1:innerFlow2", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline1_2", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1_2:innerJobA", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline1_1:innerFlow2").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline1_1", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline1_1:innerFlow2", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline1_2", Status.RUNNING);
        pipelineExpectedStateMap.put("pipeline1_2:innerJobA", Status.QUEUED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"prev:pipeline1_2:innerFlow2").succeedJob();
        this.pause(250L);
        previousExpectedStateMap.put("pipeline1_2:innerFlow2", Status.SUCCEEDED);
        previousExpectedStateMap.put("pipeline1_2", Status.SUCCEEDED);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)previousFlow.getStatus());
        Assert.assertFalse((boolean)thread1.isAlive());
        pipelineExpectedStateMap.put("pipeline1_2:innerJobA", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline1_2:innerJobA").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline1_2:innerJobA", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline1_2:innerFlow2", Status.RUNNING);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        InteractiveTestJob.getTestJob((String)"pipe:pipeline1_2:innerFlow2").succeedJob();
        this.pause(250L);
        pipelineExpectedStateMap.put("pipeline1_2", Status.SUCCEEDED);
        pipelineExpectedStateMap.put("pipeline1_2:innerFlow2", Status.SUCCEEDED);
        this.compareStates(previousExpectedStateMap, previousNodeMap);
        this.compareStates(pipelineExpectedStateMap, pipelineNodeMap);
        Assert.assertEquals((Object)Status.SUCCEEDED, (Object)pipelineFlow.getStatus());
        Assert.assertFalse((boolean)thread2.isAlive());
    }

    private Thread runFlowRunnerInThread(FlowRunner runner) {
        Thread thread = new Thread((Runnable)runner);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause(long millisec) {
        FlowRunnerPipelineTest flowRunnerPipelineTest = this;
        synchronized (flowRunnerPipelineTest) {
            try {
                this.wait(millisec);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void createExpectedStateMap(ExecutableFlowBase flow, Map<String, Status> expectedStateMap, Map<String, ExecutableNode> nodeMap) {
        for (ExecutableNode node : flow.getExecutableNodes()) {
            expectedStateMap.put(node.getNestedId(), node.getStatus());
            nodeMap.put(node.getNestedId(), node);
            if (!(node instanceof ExecutableFlowBase)) continue;
            this.createExpectedStateMap((ExecutableFlowBase)node, expectedStateMap, nodeMap);
        }
    }

    private void compareStates(Map<String, Status> expectedStateMap, Map<String, ExecutableNode> nodeMap) {
        for (String printedId : expectedStateMap.keySet()) {
            Status expectedStatus = expectedStateMap.get(printedId);
            ExecutableNode node = nodeMap.get(printedId);
            if (node == null) {
                System.out.println("id node: " + printedId + " doesn't exist.");
            }
            if (expectedStatus == node.getStatus()) continue;
            Assert.fail((String)("Expected values do not match for " + printedId + ". Expected " + expectedStatus + ", instead received " + node.getStatus()));
        }
    }

    private void prepareProject(File directory) throws ProjectManagerException, IOException {
        DirectoryFlowLoader loader = new DirectoryFlowLoader(this.logger);
        loader.loadProjectFlow(directory);
        if (!loader.getErrors().isEmpty()) {
            for (String error : loader.getErrors()) {
                System.out.println(error);
            }
            throw new RuntimeException("Errors found in setup");
        }
        this.flowMap = loader.getFlowMap();
        this.project.setFlows(this.flowMap);
        FileUtils.copyDirectory((File)directory, (File)this.workingDir);
    }

    private FlowRunner createFlowRunner(EventCollectorListener eventCollector, String flowName, String groupName) throws Exception {
        return this.createFlowRunner(eventCollector, flowName, groupName, new ExecutionOptions());
    }

    private FlowRunner createFlowRunner(EventCollectorListener eventCollector, String flowName, String groupName, ExecutionOptions options) throws Exception {
        Flow flow = (Flow)this.flowMap.get(flowName);
        int exId = id++;
        ExecutableFlow exFlow = new ExecutableFlow(this.project, flow);
        exFlow.setExecutionPath(this.workingDir.getPath());
        exFlow.setExecutionId(exId);
        HashMap<String, String> flowParam = new HashMap<String, String>();
        flowParam.put("group", groupName);
        options.addAllFlowParameters(flowParam);
        exFlow.setExecutionOptions(options);
        this.fakeExecutorLoader.uploadExecutableFlow(exFlow);
        FlowRunner runner = new FlowRunner(this.fakeExecutorLoader.fetchExecutableFlow(exId), this.fakeExecutorLoader, this.fakeProjectLoader, this.jobtypeManager);
        runner.addListener((EventListener)eventCollector);
        return runner;
    }
}

