/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectManagerException;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ProjectVersion
implements Comparable<ProjectVersion> {
    private final int projectId;
    private final int version;
    private File installedDir;

    public ProjectVersion(int projectId, int version) {
        this.projectId = projectId;
        this.version = version;
    }

    public ProjectVersion(int projectId, int version, File installedDir) {
        this.projectId = projectId;
        this.version = version;
        this.installedDir = installedDir;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getVersion() {
        return this.version;
    }

    public synchronized void setupProjectFiles(ProjectLoader projectLoader, File projectDir, Logger logger) throws ProjectManagerException, IOException {
        block7: {
            String projectVersion = String.valueOf(String.valueOf(this.projectId)) + "." + String.valueOf(this.version);
            if (this.installedDir == null) {
                this.installedDir = new File(projectDir, projectVersion);
            }
            if (!this.installedDir.exists()) {
                logger.info((Object)("First time executing new project. Setting up in directory " + this.installedDir.getPath()));
                File tempDir = new File(projectDir, "_temp." + projectVersion + "." + System.currentTimeMillis());
                tempDir.mkdirs();
                ProjectFileHandler projectFileHandler = null;
                try {
                    projectFileHandler = projectLoader.getUploadedFile(this.projectId, this.version);
                    if ("zip".equals(projectFileHandler.getFileType())) {
                        logger.info((Object)"Downloading zip file.");
                        ZipFile zip = new ZipFile(projectFileHandler.getLocalFile());
                        Utils.unzip((ZipFile)zip, (File)tempDir);
                        tempDir.renameTo(this.installedDir);
                        break block7;
                    }
                    throw new IOException("The file type hasn't been decided yet.");
                }
                finally {
                    if (projectFileHandler != null) {
                        projectFileHandler.deleteLocalFile();
                    }
                }
            }
        }
    }

    public synchronized void copyCreateSymlinkDirectory(File executionDir) throws IOException {
        if (this.installedDir == null || !this.installedDir.exists()) {
            throw new IOException("Installed dir doesn't exist");
        }
        if (executionDir == null || !executionDir.exists()) {
            throw new IOException("Execution dir doesn't exist");
        }
        FileIOUtils.createDeepSymlink((File)this.installedDir, (File)executionDir);
    }

    public synchronized void deleteDirectory() throws IOException {
        System.out.println("Deleting old unused project versin " + this.installedDir);
        if (this.installedDir != null && this.installedDir.exists()) {
            FileUtils.deleteDirectory((File)this.installedDir);
        }
    }

    @Override
    public int compareTo(ProjectVersion o) {
        if (this.projectId == o.projectId) {
            return this.version - o.version;
        }
        return this.projectId - o.projectId;
    }
}

