/*
 * Decompiled with CFR 0.152.
 */
package azkaban.user;

import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.user.UserManagerException;
import azkaban.utils.Props;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUserManager
implements UserManager {
    private static final Logger logger = Logger.getLogger((String)XmlUserManager.class.getName());
    public static final String XML_FILE_PARAM = "user.manager.xml.file";
    public static final String AZKABAN_USERS_TAG = "azkaban-users";
    public static final String USER_TAG = "user";
    public static final String ROLE_TAG = "role";
    public static final String GROUP_TAG = "group";
    public static final String ROLENAME_ATTR = "name";
    public static final String ROLEPERMISSIONS_ATTR = "permissions";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String EMAIL_ATTR = "email";
    public static final String ROLES_ATTR = "roles";
    public static final String PROXY_ATTR = "proxy";
    public static final String GROUPS_ATTR = "groups";
    public static final String GROUPNAME_ATTR = "name";
    private String xmlPath;
    private HashMap<String, User> users;
    private HashMap<String, String> userPassword;
    private HashMap<String, Role> roles;
    private HashMap<String, Set<String>> groupRoles;
    private HashMap<String, Set<String>> proxyUserMap;

    public XmlUserManager(Props props) {
        this.xmlPath = props.getString(XML_FILE_PARAM);
        this.parseXMLFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXMLFile() {
        File file = new File(this.xmlPath);
        if (!file.exists()) {
            throw new IllegalArgumentException("User xml file " + this.xmlPath + " doesn't exist.");
        }
        HashMap users = new HashMap();
        HashMap userPassword = new HashMap();
        HashMap roles = new HashMap();
        HashMap groupRoles = new HashMap();
        HashMap proxyUserMap = new HashMap();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Exception while parsing user xml. Document builder not created.", e);
        }
        Document doc = null;
        try {
            doc = builder.parse(file);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Exception while parsing " + this.xmlPath + ". Invalid XML.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while parsing " + this.xmlPath + ". Error reading file.", e);
        }
        NodeList tagList = doc.getChildNodes();
        Node azkabanUsers = tagList.item(0);
        NodeList azkabanUsersList = azkabanUsers.getChildNodes();
        int i = 0;
        while (i < azkabanUsersList.getLength()) {
            Node node = azkabanUsersList.item(i);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals(USER_TAG)) {
                    this.parseUserTag(node, users, userPassword, proxyUserMap);
                } else if (node.getNodeName().equals(ROLE_TAG)) {
                    this.parseRoleTag(node, roles);
                } else if (node.getNodeName().equals(GROUP_TAG)) {
                    this.parseGroupRoleTag(node, groupRoles);
                }
            }
            ++i;
        }
        XmlUserManager xmlUserManager = this;
        synchronized (xmlUserManager) {
            this.users = users;
            this.userPassword = userPassword;
            this.roles = roles;
            this.proxyUserMap = proxyUserMap;
            this.groupRoles = groupRoles;
        }
    }

    private void parseUserTag(Node node, HashMap<String, User> users, HashMap<String, String> userPassword, HashMap<String, Set<String>> proxyUserMap) {
        Node emailAttr;
        Node groups;
        Node proxy;
        int n;
        NamedNodeMap userAttrMap = node.getAttributes();
        Node userNameAttr = userAttrMap.getNamedItem(USERNAME_ATTR);
        if (userNameAttr == null) {
            throw new RuntimeException("Error loading user. The 'username' attribute doesn't exist");
        }
        Node passwordAttr = userAttrMap.getNamedItem(PASSWORD_ATTR);
        if (passwordAttr == null) {
            throw new RuntimeException("Error loading user. The 'password' attribute doesn't exist");
        }
        String username = userNameAttr.getNodeValue();
        String password = passwordAttr.getNodeValue();
        userPassword.put(username, password);
        User user = new User(userNameAttr.getNodeValue());
        users.put(username, user);
        logger.info((Object)("Loading user " + user.getUserId()));
        Node roles = userAttrMap.getNamedItem(ROLES_ATTR);
        if (roles != null) {
            String[] roleSplit;
            String value = roles.getNodeValue();
            String[] stringArray = roleSplit = value.split("\\s*,\\s*");
            n = roleSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                user.addRole(role);
                ++n2;
            }
        }
        if ((proxy = userAttrMap.getNamedItem(PROXY_ATTR)) != null) {
            String[] proxySplit;
            String value = proxy.getNodeValue();
            String[] stringArray = proxySplit = value.split("\\s*,\\s*");
            int n3 = proxySplit.length;
            n = 0;
            while (n < n3) {
                String proxyUser = stringArray[n];
                Set<String> proxySet = proxyUserMap.get(username);
                if (proxySet == null) {
                    proxySet = new HashSet<String>();
                    proxyUserMap.put(username, proxySet);
                }
                proxySet.add(proxyUser);
                ++n;
            }
        }
        if ((groups = userAttrMap.getNamedItem(GROUPS_ATTR)) != null) {
            String[] groupSplit;
            String value = groups.getNodeValue();
            String[] stringArray = groupSplit = value.split("\\s*,\\s*");
            int n4 = groupSplit.length;
            int n5 = 0;
            while (n5 < n4) {
                String group = stringArray[n5];
                user.addGroup(group);
                ++n5;
            }
        }
        if ((emailAttr = userAttrMap.getNamedItem(EMAIL_ATTR)) != null) {
            user.setEmail(emailAttr.getNodeValue());
        }
    }

    private void parseRoleTag(Node node, HashMap<String, Role> roles) {
        NamedNodeMap roleAttrMap = node.getAttributes();
        Node roleNameAttr = roleAttrMap.getNamedItem("name");
        if (roleNameAttr == null) {
            throw new RuntimeException("Error loading role. The role 'name' attribute doesn't exist");
        }
        Node permissionAttr = roleAttrMap.getNamedItem(ROLEPERMISSIONS_ATTR);
        if (permissionAttr == null) {
            throw new RuntimeException("Error loading role. The role 'permissions' attribute doesn't exist");
        }
        String roleName = roleNameAttr.getNodeValue();
        String permissions = permissionAttr.getNodeValue();
        String[] permissionSplit = permissions.split("\\s*,\\s*");
        Permission perm = new Permission();
        String[] stringArray = permissionSplit;
        int n = permissionSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String permString = stringArray[n2];
            try {
                Permission.Type type = Permission.Type.valueOf((String)permString);
                perm.addPermission(new Permission.Type[]{type});
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("Error adding type " + permString + ". Permission doesn't exist."), (Throwable)e);
            }
            ++n2;
        }
        Role role = new Role(roleName, perm);
        roles.put(roleName, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username, String password) throws UserManagerException {
        if (username == null || username.trim().isEmpty()) {
            throw new UserManagerException("Username is empty.");
        }
        if (password == null || password.trim().isEmpty()) {
            throw new UserManagerException("Password is empty.");
        }
        String foundPassword = null;
        User user = null;
        XmlUserManager xmlUserManager = this;
        synchronized (xmlUserManager) {
            foundPassword = (String)this.userPassword.get(username);
            if (foundPassword != null) {
                user = (User)this.users.get(username);
            }
        }
        if (foundPassword == null || !foundPassword.equals(password)) {
            throw new UserManagerException("Username/Password not found.");
        }
        if (user == null) {
            throw new UserManagerException("Internal error: User not found.");
        }
        this.resolveGroupRoles(user);
        user.setPermissions((User.UserPermissions)new /* Unavailable Anonymous Inner Class!! */);
        return user;
    }

    private void resolveGroupRoles(User user) {
        for (String group : user.getGroups()) {
            Set groupRoleSet = (Set)this.groupRoles.get(group);
            if (groupRoleSet == null) continue;
            for (String role : groupRoleSet) {
                user.addRole(role);
            }
        }
    }

    private void parseGroupRoleTag(Node node, HashMap<String, Set<String>> groupRoles) {
        NamedNodeMap groupAttrMap = node.getAttributes();
        Node groupNameAttr = groupAttrMap.getNamedItem("name");
        if (groupNameAttr == null) {
            throw new RuntimeException("Error loading role. The role 'name' attribute doesn't exist");
        }
        String groupName = groupNameAttr.getNodeValue();
        HashSet<String> roleSet = new HashSet<String>();
        Node roles = groupAttrMap.getNamedItem(ROLES_ATTR);
        if (roles != null) {
            String[] roleSplit;
            String value = roles.getNodeValue();
            String[] stringArray = roleSplit = value.split("\\s*,\\s*");
            int n = roleSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                roleSet.add(role);
                ++n2;
            }
        }
        groupRoles.put(groupName, roleSet);
        logger.info((Object)("Group roles " + groupName + " added."));
    }

    public boolean validateUser(String username) {
        return this.users.containsKey(username);
    }

    public Role getRole(String roleName) {
        return (Role)this.roles.get(roleName);
    }

    public boolean validateGroup(String group) {
        return true;
    }

    public boolean validateProxyUser(String proxyUser, User realUser) {
        return this.proxyUserMap.containsKey(realUser.getUserId()) && ((Set)this.proxyUserMap.get(realUser.getUserId())).contains(proxyUser);
    }
}

