/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Iterator;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.RemoteCacheException;
import net.sf.ehcache.store.MemoryLimitedCacheLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStoreBootstrapCacheLoader
extends MemoryLimitedCacheLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DiskStoreBootstrapCacheLoader.class);
    private final boolean asynchronous;
    private final long delay;
    private volatile boolean doneLoading;
    private volatile int loadedElements;

    DiskStoreBootstrapCacheLoader(long delay) {
        this.asynchronous = true;
        this.delay = delay;
    }

    public DiskStoreBootstrapCacheLoader(boolean asynchronous) {
        this.asynchronous = asynchronous;
        this.delay = 0L;
    }

    public void load(Ehcache cache) throws CacheException {
        if (cache.getCacheConfiguration().isDiskPersistent()) {
            if (this.asynchronous) {
                BootstrapThread thread = new BootstrapThread(cache);
                thread.start();
            } else {
                this.doLoad(cache);
            }
        } else {
            LOG.warn("Cache '" + cache.getName() + "' isn't disk persistent, nothing to laod from!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad(Ehcache cache) {
        this.loadedElements = 0;
        try {
            Iterator iterator = cache.getKeys().iterator();
            while (iterator.hasNext() && !this.isInMemoryLimitReached(cache, this.loadedElements)) {
                if (cache.get(iterator.next()) == null) continue;
                ++this.loadedElements;
            }
        }
        finally {
            this.doneLoading = true;
        }
        LOG.debug("Loaded {} elements from disk into heap for cache {}", (Object)this.loadedElements, (Object)cache.getName());
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    boolean isDoneLoading() {
        return this.doneLoading;
    }

    int getLoadedElements() {
        return this.loadedElements;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private final class BootstrapThread
    extends Thread {
        private Ehcache cache;

        public BootstrapThread(Ehcache cache) {
            super("Bootstrap Thread for cache " + cache.getName());
            this.cache = cache;
            this.setDaemon(true);
            this.setPriority(5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                BootstrapThread.sleep(DiskStoreBootstrapCacheLoader.this.delay);
                try {
                    DiskStoreBootstrapCacheLoader.this.doLoad(this.cache);
                }
                catch (RemoteCacheException e) {
                    LOG.warn("Error asynchronously performing bootstrap. The cause was: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                BootstrapThread.interrupted();
            }
            finally {
                this.cache = null;
            }
        }
    }
}

