/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import java.io.File;

public class ProjectFileHandler {
    private final int projectId;
    private final int version;
    private final long uploadTime;
    private String fileType;
    private String fileName;
    private String uploader;
    private byte[] md5Hash;
    private int numChunks;
    private File localFile = null;

    public ProjectFileHandler(int projectId, int version, long uploadTime, String uploader, String fileType, String fileName, int numChunks, byte[] md5Hash) {
        this.projectId = projectId;
        this.version = version;
        this.uploadTime = uploadTime;
        this.setUploader(uploader);
        this.setFileType(fileType);
        this.setFileName(fileName);
        this.setMd5Hash(md5Hash);
        this.setNumChunks(numChunks);
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getVersion() {
        return this.version;
    }

    public long getUploadTime() {
        return this.uploadTime;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getMd5Hash() {
        return this.md5Hash;
    }

    public void setMd5Hash(byte[] md5Hash) {
        this.md5Hash = md5Hash;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public synchronized void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public synchronized void deleteLocalFile() {
        if (this.localFile == null) {
            return;
        }
        this.localFile.delete();
        this.localFile = null;
    }

    public String getUploader() {
        return this.uploader;
    }

    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public void setNumChunks(int numChunks) {
        this.numChunks = numChunks;
    }
}

