/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp.event;

import azkaban.execapp.event.Event;

public class Event {
    private final Object runner;
    private final Type type;
    private final Object eventData;
    private final long time;
    private final boolean shouldUpdate;

    private Event(Object runner, Type type, Object eventData, boolean shouldUpdate) {
        this.runner = runner;
        this.type = type;
        this.eventData = eventData;
        this.time = System.currentTimeMillis();
        this.shouldUpdate = shouldUpdate;
    }

    public Object getRunner() {
        return this.runner;
    }

    public Type getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public Object getData() {
        return this.eventData;
    }

    public static Event create(Object runner, Type type) {
        return new Event(runner, type, null, true);
    }

    public static Event create(Object runner, Type type, Object eventData) {
        return new Event(runner, type, eventData, true);
    }

    public static Event create(Object runner, Type type, Object eventData, boolean shouldUpdate) {
        return new Event(runner, type, eventData, shouldUpdate);
    }

    public boolean isShouldUpdate() {
        return this.shouldUpdate;
    }
}

